/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.network.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.io.NetworkWriterHandler;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.misc.Time;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.matsim.utils.objectattributes.attributable.AttributesXmlWriterDelegate;

class NetworkWriterHandlerImplV2
implements NetworkWriterHandler {
    private final CoordinateTransformation transformation;
    private final AttributesXmlWriterDelegate attributesWriter = new AttributesXmlWriterDelegate();
    private Set<String> lastSet = null;
    private String lastModes = null;

    NetworkWriterHandlerImplV2(CoordinateTransformation transformation) {
        this.transformation = transformation;
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.attributesWriter.putAttributeConverters(converters);
    }

    @Override
    public void startNetwork(Network network, BufferedWriter out) throws IOException {
        out.write("<network");
        if (network.getName() != null) {
            out.write(" name=\"" + network.getName() + "\"");
        }
        out.write(">\n\n");
        this.attributesWriter.writeAttributes("\t", out, network.getAttributes());
    }

    @Override
    public void endNetwork(BufferedWriter out) throws IOException {
        out.write("</network>\n");
    }

    @Override
    public void startNodes(Network network, BufferedWriter out) throws IOException {
        out.write("\t<nodes>\n");
    }

    @Override
    public void endNodes(BufferedWriter out) throws IOException {
        out.write("\t</nodes>\n\n");
    }

    @Override
    public void startLinks(Network network, BufferedWriter out) throws IOException {
        out.write("\t<links");
        if (network.getCapacityPeriod() != -2.147483648E9) {
            out.write(" capperiod=\"" + Time.writeTime(network.getCapacityPeriod()) + "\"");
        }
        out.write(" effectivecellsize=\"" + network.getEffectiveCellSize() + "\"");
        out.write(" effectivelanewidth=\"" + network.getEffectiveLaneWidth() + "\"");
        out.write(">\n");
    }

    @Override
    public void endLinks(BufferedWriter out) throws IOException {
        out.write("\t</links>\n\n");
    }

    @Override
    public void startNode(Node node, BufferedWriter out) throws IOException {
        out.write("\t\t<node");
        out.write(" id=\"" + node.getId() + "\"");
        Coord coord = this.transformation.transform(node.getCoord());
        out.write(" x=\"" + coord.getX() + "\"");
        out.write(" y=\"" + coord.getY() + "\"");
        if (coord.hasZ()) {
            out.write(" z=\"" + coord.getZ() + "\"");
        }
        if (NetworkUtils.getType(node) != null) {
            out.write(" type=\"" + NetworkUtils.getType(node) + "\"");
        }
        if (NetworkUtils.getOrigId(node) != null) {
            out.write(" origid=\"" + NetworkUtils.getOrigId(node) + "\"");
        }
        out.write(" >\n");
        this.attributesWriter.writeAttributes("\t\t\t", out, node.getAttributes());
    }

    @Override
    public void endNode(BufferedWriter out) throws IOException {
        out.write("\t\t</node>\n");
    }

    @Override
    public void startLink(Link link, BufferedWriter out) throws IOException {
        out.write("\t\t<link");
        out.write(" id=\"" + link.getId() + "\"");
        out.write(" from=\"" + link.getFromNode().getId() + "\"");
        out.write(" to=\"" + link.getToNode().getId() + "\"");
        out.write(" length=\"" + link.getLength() + "\"");
        out.write(" freespeed=\"" + link.getFreespeed() + "\"");
        out.write(" capacity=\"" + link.getCapacity() + "\"");
        out.write(" permlanes=\"" + link.getNumberOfLanes() + "\"");
        out.write(" oneway=\"1\"");
        Set<String> modes = link.getAllowedModes();
        if (modes != null) {
            if (modes != this.lastSet) {
                StringBuilder buffer = new StringBuilder();
                int counter = 0;
                for (String mode : modes) {
                    if (counter > 0) {
                        buffer.append(',');
                    }
                    buffer.append(mode);
                    ++counter;
                }
                this.lastModes = buffer.toString();
                this.lastSet = modes;
            }
            out.write(" modes=\"" + this.lastModes + "\"");
        }
        out.write(" >\n");
        this.attributesWriter.writeAttributes("\t\t\t", out, link.getAttributes());
    }

    @Override
    public void endLink(BufferedWriter out) throws IOException {
        out.write("\t\t</link>\n");
    }

    @Override
    public void writeSeparator(BufferedWriter out) throws IOException {
        out.write("<!-- ====================================================================== -->\n\n");
    }
}

