/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population;

import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.core.utils.misc.Time;
import org.matsim.facilities.ActivityFacility;
import org.matsim.utils.objectattributes.attributable.Attributes;

final class ActivityImpl
implements Activity {
    private double endTime = Time.getUndefinedTime();
    private double startTime = Time.getUndefinedTime();
    private double dur = Time.getUndefinedTime();
    private String type;
    private Coord coord = null;
    private Id<Link> linkId = null;
    private Id<ActivityFacility> facilityId = null;
    private final Attributes attributes = new Attributes();

    ActivityImpl(String type) {
        this.type = type.intern();
    }

    @Override
    public final double getEndTime() {
        return this.endTime;
    }

    @Override
    public final void setEndTime(double endTime) {
        this.endTime = endTime;
    }

    @Override
    public final double getStartTime() {
        return this.startTime;
    }

    @Override
    public final void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final void setType(String type) {
        this.type = type.intern();
    }

    @Override
    public final Coord getCoord() {
        return this.coord;
    }

    @Override
    public void setCoord(Coord coord) {
        this.coord = coord;
    }

    @Override
    public final Id<Link> getLinkId() {
        return this.linkId;
    }

    @Override
    public final Id<ActivityFacility> getFacilityId() {
        return this.facilityId;
    }

    @Override
    public final void setFacilityId(Id<ActivityFacility> facilityId) {
        this.facilityId = facilityId;
    }

    @Override
    public final void setLinkId(Id<Link> linkId) {
        this.linkId = linkId;
    }

    public final String toString() {
        return "act [type=" + this.getType() + "]" + "[coord=" + this.getCoord() + "]" + "[linkId=" + this.linkId + "]" + "[startTime=" + Time.writeTime(this.getStartTime()) + "]" + "[endTime=" + Time.writeTime(this.getEndTime()) + "]" + "[duration=" + Time.writeTime(this.getMaximumDuration()) + "]" + "[facilityId=" + this.facilityId + "]";
    }

    @Override
    public double getMaximumDuration() {
        return this.dur;
    }

    @Override
    public void setMaximumDuration(double dur) {
        this.dur = dur;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }
}

