/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population;

import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.core.population.PopulationUtils;

public final class PersonUtils {
    private static final String SEX_ATTRIBUTE = "sex";
    private static final String HAS_LICENSE = "hasLicense";
    private static final String CAR_AVAIL = "carAvail";
    private static final String EMPLOYED = "employed";
    private static final String AGE = "age";
    private static final String TRAVELCARDS = "travelcards";
    private static final Logger log = Logger.getLogger(Person.class);

    private PersonUtils() {
    }

    @Deprecated
    public static Plan createAndAddPlan(Person person, boolean selected) {
        Plan p = PopulationUtils.createPlan(person);
        person.addPlan(p);
        if (selected) {
            person.setSelectedPlan(p);
        }
        return p;
    }

    public static void removeUnselectedPlans(Person person) {
        Iterator iter = person.getPlans().iterator();
        while (iter.hasNext()) {
            Plan plan = (Plan)iter.next();
            if (PersonUtils.isSelected(plan)) continue;
            iter.remove();
        }
    }

    public static String getSex(Person person) {
        return (String)person.getAttributes().getAttribute(SEX_ATTRIBUTE);
    }

    public static Integer getAge(Person person) {
        return (Integer)person.getAttributes().getAttribute(AGE);
    }

    public static String getLicense(Person person) {
        return (String)person.getAttributes().getAttribute(HAS_LICENSE);
    }

    public static boolean hasLicense(Person person) {
        return "yes".equals(PersonUtils.getLicense(person)) || "true".equals(PersonUtils.getLicense(person));
    }

    public static String getCarAvail(Person person) {
        return (String)person.getAttributes().getAttribute(CAR_AVAIL);
    }

    public static Boolean isEmployed(Person person) {
        return (Boolean)person.getAttributes().getAttribute(EMPLOYED);
    }

    public static void setAge(Person person, Integer age) {
        if (age != null) {
            person.getCustomAttributes().put(AGE, age);
            person.getAttributes().putAttribute(AGE, age);
        }
    }

    public static void setSex(Person person, String sex) {
        if (sex != null) {
            person.getCustomAttributes().put(SEX_ATTRIBUTE, sex);
            person.getAttributes().putAttribute(SEX_ATTRIBUTE, sex);
        }
    }

    public static void setLicence(Person person, String licence) {
        if (licence != null) {
            person.getCustomAttributes().put(HAS_LICENSE, licence);
            person.getAttributes().putAttribute(HAS_LICENSE, licence);
        }
    }

    public static void setCarAvail(Person person, String carAvail) {
        if (carAvail != null) {
            person.getCustomAttributes().put(CAR_AVAIL, carAvail);
            person.getAttributes().putAttribute(CAR_AVAIL, carAvail);
        }
    }

    public static void setEmployed(Person person, Boolean employed) {
        if (employed != null) {
            person.getCustomAttributes().put(EMPLOYED, employed);
            person.getAttributes().putAttribute(EMPLOYED, employed);
        }
    }

    @Deprecated
    public static void addTravelcard(Person person, String type) {
        if (PersonUtils.getTravelcards(person) == null) {
            person.getCustomAttributes().put(TRAVELCARDS, new TreeSet());
        }
        if (PersonUtils.getTravelcards(person).contains(type)) {
            log.info(person + "[type=" + type + " already exists]");
        } else {
            PersonUtils.getTravelcards(person).add(type.intern());
        }
    }

    @Deprecated
    public static TreeSet<String> getTravelcards(Person person) {
        return (TreeSet)person.getCustomAttributes().get(TRAVELCARDS);
    }

    public static boolean isSelected(Plan plan) {
        return plan.getPerson().getSelectedPlan() == plan;
    }
}

