/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population;

import javax.inject.Inject;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.population.ActivityImpl;
import org.matsim.core.population.LegImpl;
import org.matsim.core.population.PersonImpl;
import org.matsim.core.population.PlanImpl;
import org.matsim.core.population.routes.RouteFactories;
import org.matsim.core.population.routes.RouteFactory;
import org.matsim.facilities.ActivityFacility;

class PopulationFactoryImpl
implements PopulationFactory {
    private final RouteFactories routeFactory;

    @Inject
    PopulationFactoryImpl(RouteFactories routeFactory) {
        this.routeFactory = routeFactory;
    }

    @Override
    public Person createPerson(Id<Person> id) {
        return new PersonImpl(id);
    }

    @Override
    public Plan createPlan() {
        return new PlanImpl();
    }

    @Override
    public Activity createActivityFromCoord(String actType, Coord coord) {
        ActivityImpl act = new ActivityImpl(actType);
        act.setCoord(coord);
        return act;
    }

    @Override
    public Activity createActivityFromLinkId(String actType, Id<Link> linkId) {
        ActivityImpl act = new ActivityImpl(actType);
        act.setLinkId(linkId);
        return act;
    }

    @Override
    public Activity createActivityFromActivityFacilityId(String actType, Id<ActivityFacility> activityFacilityId) {
        ActivityImpl act = new ActivityImpl(actType);
        act.setFacilityId(activityFacilityId);
        return act;
    }

    @Override
    public Leg createLeg(String legMode) {
        return new LegImpl(legMode);
    }

    public void setRouteFactory(Class<? extends Route> routeType, RouteFactory factory) {
        this.routeFactory.setRouteFactory(routeType, factory);
    }

    @Override
    public RouteFactories getRouteFactories() {
        return this.routeFactory;
    }
}

