/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.scenario.Lockable;
import org.matsim.utils.objectattributes.attributable.Attributes;

class PopulationImpl
implements Population,
Lockable {
    private static final Logger log = Logger.getLogger(PopulationImpl.class);
    private final Attributes attributes = new Attributes();
    private String name;
    private Map<Id<Person>, Person> persons = new LinkedHashMap<Id<Person>, Person>();
    private final PopulationFactory populationFactory;
    private long counter = 0L;
    private long nextMsg = 1L;

    PopulationImpl(PopulationFactory populationFactory2) {
        this.populationFactory = populationFactory2;
    }

    @Override
    public void addPerson(Person p) {
        if (this.getPersons().containsKey(p.getId())) {
            throw new IllegalArgumentException("Person with id = " + p.getId() + " already exists.");
        }
        if (p instanceof Lockable) {
            ((Lockable)((Object)p)).setLocked();
        }
        ++this.counter;
        if (this.counter % this.nextMsg == 0L) {
            this.nextMsg *= 4L;
            this.printPlansCount();
        }
        this.persons.put(p.getId(), p);
    }

    @Override
    public Person removePerson(Id<Person> personId) {
        return this.persons.remove(personId);
    }

    @Override
    public final Map<Id<Person>, ? extends Person> getPersons() {
        return this.persons;
    }

    @Override
    public PopulationFactory getFactory() {
        return this.populationFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public final void setLocked() {
        for (Person person : this.persons.values()) {
            if (!(person instanceof Lockable)) continue;
            ((Lockable)((Object)person)).setLocked();
        }
    }

    public void printPlansCount() {
        log.info(" person # " + this.counter);
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }
}

