/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.HasPlansAndId;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.config.groups.PlansConfigGroup;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.population.ActivityImpl;
import org.matsim.core.population.PersonImpl;
import org.matsim.core.population.PopulationFactoryImpl;
import org.matsim.core.population.PopulationImpl;
import org.matsim.core.population.io.PopulationReader;
import org.matsim.core.population.io.PopulationWriter;
import org.matsim.core.population.io.StreamingPopulationReader;
import org.matsim.core.population.routes.CompressedNetworkRouteFactory;
import org.matsim.core.population.routes.LinkNetworkRouteFactory;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteFactories;
import org.matsim.core.population.routes.RouteFactory;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.router.TripStructureUtils;
import org.matsim.core.scenario.MutableScenario;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.core.utils.misc.Time;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.ActivityFacility;
import org.matsim.utils.objectattributes.attributable.Attributable;
import org.matsim.utils.objectattributes.attributable.Attributes;
import org.matsim.utils.objectattributes.attributable.AttributesUtils;

public final class PopulationUtils {
    private static final Logger log = Logger.getLogger(PopulationUtils.class);
    private static final PopulationFactory populationFactory = PopulationUtils.createPopulation(new PlansConfigGroup(), null).getFactory();
    private static int missingFacilityCnt = 0;

    private PopulationUtils() {
    }

    public static Population createPopulation(Config config) {
        return PopulationUtils.createPopulation(config, null);
    }

    public static Population createPopulation(Config config, Network network) {
        return PopulationUtils.createPopulation(config.plans(), network);
    }

    public static Population createPopulation(PlansConfigGroup plansConfigGroup, Network network) {
        RouteFactory factory;
        RouteFactories routeFactory = new RouteFactories();
        String networkRouteType = plansConfigGroup.getNetworkRouteType();
        if ("LinkNetworkRoute".equals(networkRouteType)) {
            factory = new LinkNetworkRouteFactory();
        } else if ("CompressedNetworkRoute".equals(networkRouteType) && network != null) {
            factory = new CompressedNetworkRouteFactory(network);
        } else {
            throw new IllegalArgumentException("The type \"" + networkRouteType + "\" is not a supported type for network routes.");
        }
        routeFactory.setRouteFactory(NetworkRoute.class, factory);
        return new PopulationImpl(new PopulationFactoryImpl(routeFactory));
    }

    public static Leg unmodifiableLeg(Leg leg) {
        return new UnmodifiableLeg(leg);
    }

    public static void resetRoutes(Plan plan) {
        for (PlanElement pe : plan.getPlanElements()) {
            if (!(pe instanceof Leg)) continue;
            ((Leg)pe).setRoute(null);
        }
    }

    public static Activity unmodifiableActivity(Activity act) {
        return new UnmodifiableActivity(act);
    }

    public static Plan unmodifiablePlan(Plan plan) {
        return new UnmodifiablePlan(plan);
    }

    public static SortedMap<Id<Person>, Person> getSortedPersons(Population population) {
        return new TreeMap<Id<Person>, Person>(population.getPersons());
    }

    public static void sortPersons(Population population) {
        Map<Id<Person>, ? extends Person> map = population.getPersons();
        if (map instanceof SortedMap) {
            return;
        }
        TreeMap<Id<Person>, ? extends Person> treeMap = new TreeMap<Id<Person>, Person>(map);
        map.clear();
        map.putAll(treeMap);
    }

    @Deprecated
    public static double getActivityEndTime(Activity act, double now, Config config) {
        return PopulationUtils.decideOnActivityEndTime(act, now, config);
    }

    public static double decideOnActivityEndTime(Activity act, double now, Config config) {
        switch (config.plans().getActivityDurationInterpretation()) {
            case endTimeOnly: {
                return act.getEndTime();
            }
            case tryEndTimeThenDuration: {
                if (!Time.isUndefinedTime(act.getEndTime())) {
                    return act.getEndTime();
                }
                if (!Time.isUndefinedTime(act.getMaximumDuration())) {
                    return now + act.getMaximumDuration();
                }
                return Time.getUndefinedTime();
            }
            case minOfDurationAndEndTime: {
                return Math.min(now + act.getMaximumDuration(), act.getEndTime());
            }
        }
        return Time.getUndefinedTime();
    }

    @Deprecated
    public static Id<Link> computeLinkIdFromActivity(Activity act, ActivityFacilities facs, Config config) {
        if (act.getFacilityId() == null) {
            Id<Link> linkIdFromActivity = act.getLinkId();
            Gbl.assertNotNull(linkIdFromActivity);
            return linkIdFromActivity;
        }
        ActivityFacility facility = facs.getFacilities().get(act.getFacilityId());
        if (facility == null || facility.getLinkId() == null) {
            Id<Link> linkIdFromActivity;
            if (facility == null && missingFacilityCnt < 10) {
                log.warn("we have a facility ID for an activity, but can't find the facility; this should not really happen. Falling back on link ID.");
                if (++missingFacilityCnt == 10) {
                    log.warn(" Future occurences of this logging statement are suppressed.");
                }
            }
            Gbl.assertIf((linkIdFromActivity = act.getLinkId()) != null);
            return linkIdFromActivity;
        }
        return facility.getLinkId();
    }

    @Deprecated
    public static Coord computeCoordFromActivity(Activity act, ActivityFacilities facs, Config config) {
        return PopulationUtils.computeCoordFromActivity(act, facs, null, config);
    }

    @Deprecated
    public static Coord computeCoordFromActivity(Activity act, ActivityFacilities facs, Network network, Config config) {
        if (act.getFacilityId() == null) {
            if (act.getCoord() != null) {
                return act.getCoord();
            }
            Gbl.assertNotNull(network);
            Link link = network.getLinks().get(act.getLinkId());
            return link.getCoord();
        }
        Gbl.assertIf(facs != null);
        ActivityFacility facility = facs.getFacilities().get(act.getFacilityId());
        Gbl.assertIf(facility != null);
        return facility.getCoord();
    }

    public static List<Activity> getActivities(Plan plan, StageActivityTypes stageActivities) {
        return TripStructureUtils.getActivities(plan, stageActivities);
    }

    public static List<Leg> getLegs(Plan plan) {
        return TripStructureUtils.getLegs(plan);
    }

    public static double calculateSimilarity(List<Leg> legs1, List<Leg> legs2, Network network, double sameModeReward, double sameRouteReward) {
        double simil = 0.0;
        Iterator<Leg> it1 = legs1.iterator();
        Iterator<Leg> it2 = legs2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Leg leg1 = it1.next();
            Leg leg2 = it2.next();
            if (!leg1.getMode().equals(leg2.getMode())) continue;
            simil += sameModeReward;
            Route route1 = leg1.getRoute();
            Route route2 = leg2.getRoute();
            if (!(route1 instanceof NetworkRoute)) {
                simil += sameModeReward;
                continue;
            }
            NetworkRoute nr1 = (NetworkRoute)route1;
            if (!(route2 instanceof NetworkRoute)) {
                simil += sameModeReward;
                continue;
            }
            NetworkRoute nr2 = (NetworkRoute)route2;
            simil += sameRouteReward * (RouteUtils.calculateCoverage(nr1, nr2, network) + RouteUtils.calculateCoverage(nr2, nr1, network)) / 2.0;
        }
        return simil;
    }

    public static double calculateSimilarity(List<Activity> activities1, List<Activity> activities2, double sameActivityTypePenalty, double sameActivityLocationPenalty, double actTimeParameter) {
        double simil = 0.0;
        Iterator<Activity> it1 = activities1.iterator();
        Iterator<Activity> it2 = activities2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Activity act1 = it1.next();
            Activity act2 = it2.next();
            if (act1.getType().equals(act2.getType())) {
                simil += sameActivityTypePenalty;
            }
            if (act1.getCoord().equals(act2.getCoord())) {
                simil += sameActivityLocationPenalty;
            }
            if (Double.isInfinite(act1.getEndTime()) && Double.isInfinite(act2.getEndTime())) continue;
            double delta = Math.abs(act1.getEndTime() - act2.getEndTime());
            simil += actTimeParameter * Math.exp(-delta / (300.0 / Math.log(2.0)));
        }
        return simil;
    }

    /*
     * Exception decompiling
     */
    public static boolean equalPopulation(Population s1, Population s2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputStream openPopulationInputStream(final Population s1) {
        try {
            PipedInputStream in = new PipedInputStream();
            final PipedOutputStream out = new PipedOutputStream(in);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    PopulationWriter writer = new PopulationWriter(s1);
                    try {
                        writer.write(out);
                    }
                    catch (UncheckedIOException uncheckedIOException) {
                        // empty catch block
                    }
                }
            }).start();
            return in;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Activity getFirstActivityAfterLastCarLegOfDay(Plan plan) {
        int i;
        List<PlanElement> planElements = plan.getPlanElements();
        int indexOfLastCarLegOfDay = -1;
        for (i = planElements.size() - 1; i >= 0; --i) {
            Leg leg;
            if (!(planElements.get(i) instanceof Leg) || !(leg = (Leg)planElements.get(i)).getMode().equalsIgnoreCase("car")) continue;
            indexOfLastCarLegOfDay = i;
            break;
        }
        for (i = indexOfLastCarLegOfDay + 1; i < planElements.size(); ++i) {
            if (!(planElements.get(i) instanceof Activity)) continue;
            return (Activity)planElements.get(i);
        }
        return null;
    }

    public static Activity getFirstActivityOfDayBeforeDepartingWithCar(Plan plan) {
        int i;
        List<PlanElement> planElements = plan.getPlanElements();
        int indexOfFirstCarLegOfDay = -1;
        for (i = 0; i < planElements.size(); ++i) {
            Leg leg;
            if (!(planElements.get(i) instanceof Leg) || !(leg = (Leg)planElements.get(i)).getMode().equalsIgnoreCase("car")) continue;
            indexOfFirstCarLegOfDay = i;
            break;
        }
        for (i = indexOfFirstCarLegOfDay - 1; i >= 0; --i) {
            if (!(planElements.get(i) instanceof Activity)) continue;
            return (Activity)planElements.get(i);
        }
        return null;
    }

    public static boolean hasCarLeg(Plan plan) {
        List<PlanElement> planElements = plan.getPlanElements();
        for (int i = 0; i < planElements.size(); ++i) {
            Leg Leg2;
            if (!(planElements.get(i) instanceof Leg) || !(Leg2 = (Leg)planElements.get(i)).getMode().equalsIgnoreCase("car")) continue;
            return true;
        }
        return false;
    }

    public static PopulationFactory getFactory() {
        return populationFactory;
    }

    public static Plan createPlan(Person person) {
        Plan plan = PopulationUtils.getFactory().createPlan();
        plan.setPerson(person);
        return plan;
    }

    public static Plan createPlan() {
        return PopulationUtils.getFactory().createPlan();
    }

    public static Activity createActivityFromLinkId(String type, Id<Link> linkId) {
        return PopulationUtils.getFactory().createActivityFromLinkId(type, linkId);
    }

    public static Activity createActivityFromCoord(String type, Coord coord) {
        return PopulationUtils.getFactory().createActivityFromCoord(type, coord);
    }

    public static Activity createActivityFromCoordAndLinkId(String type, Coord coord, Id<Link> linkId) {
        Activity act = PopulationUtils.getFactory().createActivityFromCoord(type, coord);
        act.setLinkId(linkId);
        return act;
    }

    public static Leg createLeg(String transportMode) {
        return PopulationUtils.getFactory().createLeg(transportMode);
    }

    public static Activity createAndAddActivityFromCoord(Plan plan, String type, Coord coord) {
        Activity act = PopulationUtils.getFactory().createActivityFromCoord(type, coord);
        plan.addActivity(act);
        act.setCoord(coord);
        return act;
    }

    public static Activity createAndAddActivityFromLinkId(Plan plan, String type, Id<Link> linkId) {
        Activity act = PopulationUtils.getFactory().createActivityFromLinkId(type, linkId);
        plan.addActivity(act);
        act.setLinkId(linkId);
        return act;
    }

    public static Leg createAndAddLeg(Plan plan, String mode) {
        PopulationUtils.verifyCreateLeg(plan);
        Leg leg = PopulationUtils.getFactory().createLeg(mode);
        plan.addLeg(leg);
        return leg;
    }

    private static void verifyCreateLeg(Plan plan) throws IllegalStateException {
        if (plan.getPlanElements().size() == 0) {
            throw new IllegalStateException("The order of 'acts'/'legs' is wrong in some way while trying to create a 'leg'.");
        }
    }

    public static Activity createAndAddActivity(Plan plan, String type) {
        ActivityImpl act = new ActivityImpl(type);
        plan.addActivity(act);
        return act;
    }

    public static void copyFromTo(Plan in, Plan out) {
        out.getPlanElements().clear();
        out.setScore(in.getScore());
        out.setType(in.getType());
        for (PlanElement pe : in.getPlanElements()) {
            if (pe instanceof Activity) {
                out.getPlanElements().add(PopulationUtils.createActivity((Activity)pe));
                continue;
            }
            if (pe instanceof Leg) {
                out.getPlanElements().add(PopulationUtils.createLeg((Leg)pe));
                continue;
            }
            throw new IllegalArgumentException("unrecognized plan element type discovered");
        }
        AttributesUtils.copyAttributesFromTo(in, out);
    }

    public static void copyFromTo(Leg in, Leg out) {
        out.setMode(in.getMode());
        out.setDepartureTime(in.getDepartureTime());
        out.setTravelTime(in.getTravelTime());
        if (in.getRoute() != null) {
            out.setRoute(in.getRoute().clone());
        }
        AttributesUtils.copyAttributesFromTo(in, out);
    }

    public static void copyFromTo(Activity act, Activity newAct) {
        Coord coord = act.getCoord() == null ? null : new Coord(act.getCoord().getX(), act.getCoord().getY());
        newAct.setCoord(coord);
        newAct.setType(act.getType());
        newAct.setLinkId(act.getLinkId());
        newAct.setStartTime(act.getStartTime());
        newAct.setEndTime(act.getEndTime());
        newAct.setMaximumDuration(act.getMaximumDuration());
        newAct.setFacilityId(act.getFacilityId());
        AttributesUtils.copyAttributesFromTo(act, newAct);
    }

    public static Activity createActivity(Activity act) {
        Activity newAct = PopulationUtils.getFactory().createActivityFromLinkId(act.getType(), act.getLinkId());
        PopulationUtils.copyFromTo(act, newAct);
        return newAct;
    }

    public static Leg createLeg(Leg leg) {
        Leg newLeg = PopulationUtils.createLeg(leg.getMode());
        PopulationUtils.copyFromTo(leg, newLeg);
        return newLeg;
    }

    public static Activity getFirstActivity(Plan plan) {
        return (Activity)plan.getPlanElements().get(0);
    }

    public static Activity getLastActivity(Plan plan) {
        return (Activity)plan.getPlanElements().get(plan.getPlanElements().size() - 1);
    }

    public static Activity getNextActivity(Plan plan, Leg leg) {
        int index = PopulationUtils.getActLegIndex(plan, leg);
        if (index != -1) {
            return (Activity)plan.getPlanElements().get(index + 1);
        }
        return null;
    }

    public static int getActLegIndex(Plan plan, PlanElement pe) {
        if (pe instanceof Leg || pe instanceof Activity) {
            for (int i = 0; i < plan.getPlanElements().size(); ++i) {
                if (!plan.getPlanElements().get(i).equals(pe)) continue;
                return i;
            }
            return -1;
        }
        throw new IllegalArgumentException("Method call only valid with a Leg or Act instance as parameter!");
    }

    public static Leg getNextLeg(Plan plan, Activity act) {
        int index = PopulationUtils.getActLegIndex(plan, act);
        if (index < plan.getPlanElements().size() - 1 && index != -1) {
            return (Leg)plan.getPlanElements().get(index + 1);
        }
        return null;
    }

    public static Activity getPreviousActivity(Plan plan, Leg leg) {
        int index = PopulationUtils.getActLegIndex(plan, leg);
        if (index != -1) {
            return (Activity)plan.getPlanElements().get(index - 1);
        }
        return null;
    }

    public static Leg getPreviousLeg(Plan plan, Activity act) {
        int index = PopulationUtils.getActLegIndex(plan, act);
        if (index != -1) {
            return (Leg)plan.getPlanElements().get(index - 1);
        }
        return null;
    }

    public static void removeLeg(Plan plan, int index) {
        if (index % 2 == 0 || index < 1 || index >= plan.getPlanElements().size() - 1) {
            log.warn(plan + "[index=" + index + " is wrong. nothing removed]");
        } else {
            if (index != plan.getPlanElements().size() - 2) {
                Leg next_leg = (Leg)plan.getPlanElements().get(index + 2);
                next_leg.setDepartureTime(Time.getUndefinedTime());
                next_leg.setTravelTime(Time.getUndefinedTime());
                next_leg.setRoute(null);
            }
            plan.getPlanElements().remove(index + 1);
            plan.getPlanElements().remove(index);
        }
    }

    public static void removeActivity(Plan plan, int index) {
        if (index % 2 != 0 || index < 0 || index > plan.getPlanElements().size() - 1) {
            log.warn(plan + "[index=" + index + " is wrong. nothing removed]");
        } else if (plan.getPlanElements().size() == 1) {
            log.warn(plan + "[index=" + index + " only one act. nothing removed]");
        } else if (index == 0) {
            plan.getPlanElements().remove(index + 1);
            plan.getPlanElements().remove(index);
        } else if (index == plan.getPlanElements().size() - 1) {
            plan.getPlanElements().remove(index);
            plan.getPlanElements().remove(index - 1);
        } else {
            Leg prev_leg = (Leg)plan.getPlanElements().get(index - 1);
            prev_leg.setDepartureTime(Time.getUndefinedTime());
            prev_leg.setTravelTime(Time.getUndefinedTime());
            prev_leg.setRoute(null);
            plan.getPlanElements().remove(index + 1);
            plan.getPlanElements().remove(index);
        }
    }

    public static void insertLegAct(Plan plan, int pos, Leg leg, Activity act) {
        if (pos < plan.getPlanElements().size()) {
            PlanElement o = plan.getPlanElements().get(pos);
            if (!(o instanceof Leg)) {
                throw new IllegalArgumentException("Position to insert leg and act is not valid (act instead of leg at position).");
            }
        } else if (pos > plan.getPlanElements().size()) {
            throw new IllegalArgumentException("Position to insert leg and act is not valid.");
        }
        plan.getPlanElements().add(pos, act);
        plan.getPlanElements().add(pos, leg);
    }

    public static void changePersonId(Person person, Id<Person> id) {
        if (!(person instanceof PersonImpl)) {
            throw new RuntimeException("wrong implementation of interface Person");
        }
        ((PersonImpl)person).changeId(id);
    }

    public static void printPlansCount(Population population) {
        log.info(" person # " + population.getPersons().size());
    }

    public static void printPlansCount(StreamingPopulationReader reader) {
        reader.printPlansCount();
    }

    public static void writePopulation(Population population, String filename) {
        new PopulationWriter(population).write(filename);
    }

    public static Id<Link> decideOnLinkIdForActivity(Activity act, Scenario sc) {
        if (act.getFacilityId() != null) {
            ActivityFacility facility = sc.getActivityFacilities().getFacilities().get(act.getFacilityId());
            if (facility == null) {
                throw new RuntimeException("facility ID given but not in facilities container");
            }
            Gbl.assertNotNull(facility.getLinkId());
            return facility.getLinkId();
        }
        Gbl.assertNotNull(act.getLinkId());
        return act.getLinkId();
    }

    public static Coord decideOnCoordForActivity(Activity act, Scenario sc) {
        Id<ActivityFacility> facilityId;
        try {
            facilityId = act.getFacilityId();
        }
        catch (Exception ee) {
            facilityId = null;
        }
        if (facilityId != null) {
            ActivityFacility facility = sc.getActivityFacilities().getFacilities().get(facilityId);
            Gbl.assertNotNull(facility);
            Gbl.assertNotNull(facility.getCoord());
            return facility.getCoord();
        }
        if (act.getCoord() != null) {
            return act.getCoord();
        }
        Gbl.assertNotNull(sc.getNetwork());
        Link link = sc.getNetwork().getLinks().get(act.getLinkId());
        Gbl.assertNotNull(link);
        return link.getCoord();
    }

    public static double decideOnTravelTimeForLeg(Leg leg) {
        if (leg.getRoute() != null) {
            return leg.getRoute().getTravelTime();
        }
        return leg.getTravelTime();
    }

    public static void sampleDown(Population pop, double sample) {
        Random rnd = MatsimRandom.getLocalInstance();
        log.info("population size before downsampling=" + pop.getPersons().size());
        pop.getPersons().values().removeIf(person -> rnd.nextDouble() >= sample);
        log.info("population size after downsampling=" + pop.getPersons().size());
    }

    public static void readPopulation(Population population, String filename) {
        MutableScenario scenario = ScenarioUtils.createMutableScenario(ConfigUtils.createConfig());
        scenario.setPopulation(population);
        new PopulationReader(scenario).readFile(filename);
    }

    public static boolean comparePopulations(Population population1, Population population2) {
        boolean result = PopulationUtils.equalPopulation(population1, population2);
        return result;
    }

    public static Object getPersonAttribute(HasPlansAndId person, String key) {
        if (person instanceof Attributable) {
            return ((Attributable)((Object)person)).getAttributes().getAttribute(key);
        }
        return null;
    }

    public static void putPersonAttribute(Person person, String key, Object value) {
        person.getAttributes().putAttribute(key, value);
    }

    public static Object removePersonAttribute(Person person, String key) {
        return person.getAttributes().removeAttribute(key);
    }

    @Deprecated
    public static void removePersonAttributes(Person person, Population population) {
        person.getAttributes().clear();
    }

    static class UnmodifiablePlan
    implements Plan {
        private final Plan delegate;
        private final List<PlanElement> unmodifiablePlanElements;

        public UnmodifiablePlan(Plan plan) {
            this.delegate = plan;
            ArrayList<PlanElement> tmp = new ArrayList<PlanElement>();
            for (PlanElement pe : plan.getPlanElements()) {
                if (pe instanceof Activity) {
                    tmp.add(PopulationUtils.unmodifiableActivity((Activity)pe));
                    continue;
                }
                if (!(pe instanceof Leg)) continue;
                tmp.add(PopulationUtils.unmodifiableLeg((Leg)pe));
            }
            this.unmodifiablePlanElements = Collections.unmodifiableList(tmp);
        }

        @Override
        public void addActivity(Activity act) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            return this.delegate.getType();
        }

        @Override
        public void setType(String type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLeg(Leg leg) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getCustomAttributes() {
            return this.delegate.getCustomAttributes();
        }

        @Override
        public Person getPerson() {
            return this.delegate.getPerson();
        }

        @Override
        public List<PlanElement> getPlanElements() {
            return this.unmodifiablePlanElements;
        }

        @Override
        public Double getScore() {
            return this.delegate.getScore();
        }

        @Override
        public void setPerson(Person person) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setScore(Double score) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Attributes getAttributes() {
            return this.delegate.getAttributes();
        }
    }

    static class UnmodifiableActivity
    implements Activity {
        private final Activity delegate;

        public UnmodifiableActivity(Activity act) {
            this.delegate = act;
        }

        @Override
        public double getEndTime() {
            return this.delegate.getEndTime();
        }

        @Override
        public void setEndTime(double seconds) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            return this.delegate.getType();
        }

        @Override
        public void setType(String type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Coord getCoord() {
            return this.delegate.getCoord();
        }

        @Override
        public double getStartTime() {
            return this.delegate.getStartTime();
        }

        @Override
        public void setStartTime(double seconds) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getMaximumDuration() {
            return this.delegate.getMaximumDuration();
        }

        @Override
        public void setMaximumDuration(double seconds) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id<Link> getLinkId() {
            return this.delegate.getLinkId();
        }

        @Override
        public Id<ActivityFacility> getFacilityId() {
            return this.delegate.getFacilityId();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void setLinkId(Id<Link> id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setFacilityId(Id<ActivityFacility> id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCoord(Coord coord) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public Attributes getAttributes() {
            return this.delegate.getAttributes();
        }
    }

    static class UnmodifiableLeg
    implements Leg {
        private final Leg delegate;

        public UnmodifiableLeg(Leg leg) {
            this.delegate = leg;
        }

        @Override
        public String getMode() {
            return this.delegate.getMode();
        }

        @Override
        public void setMode(String mode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Route getRoute() {
            return this.delegate.getRoute();
        }

        @Override
        public void setRoute(Route route) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getDepartureTime() {
            return this.delegate.getDepartureTime();
        }

        @Override
        public void setDepartureTime(double seconds) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getTravelTime() {
            return this.delegate.getTravelTime();
        }

        @Override
        public void setTravelTime(double seconds) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public Attributes getAttributes() {
            return this.delegate.getAttributes();
        }
    }
}

