/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population;

import com.google.inject.Inject;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.config.groups.PlansConfigGroup;
import org.matsim.core.controler.events.BeforeMobsimEvent;
import org.matsim.core.controler.listener.BeforeMobsimListener;
import org.matsim.core.utils.misc.Time;

class VspPlansCleaner
implements BeforeMobsimListener {
    @Inject
    private PlansConfigGroup plansConfigGroup;
    @Inject
    private Population population;

    VspPlansCleaner() {
    }

    @Override
    public void notifyBeforeMobsim(BeforeMobsimEvent event) {
        PlansConfigGroup.ActivityDurationInterpretation actDurInterp = this.plansConfigGroup.getActivityDurationInterpretation();
        for (Person person : this.population.getPersons().values()) {
            Plan plan = (Plan)person.getSelectedPlan();
            for (PlanElement pe : plan.getPlanElements()) {
                if (pe instanceof Activity) {
                    Activity act = (Activity)pe;
                    if (actDurInterp != PlansConfigGroup.ActivityDurationInterpretation.minOfDurationAndEndTime) {
                        if (actDurInterp == PlansConfigGroup.ActivityDurationInterpretation.endTimeOnly) {
                            act.setMaximumDuration(Time.getUndefinedTime());
                        } else if (actDurInterp == PlansConfigGroup.ActivityDurationInterpretation.tryEndTimeThenDuration) {
                            if (!Time.isUndefinedTime(act.getEndTime())) {
                                act.setMaximumDuration(Time.getUndefinedTime());
                            }
                        } else {
                            throw new IllegalStateException("should not happen");
                        }
                    }
                    if (!this.plansConfigGroup.isRemovingUnneccessaryPlanAttributes()) continue;
                    act.setStartTime(Time.getUndefinedTime());
                    continue;
                }
                if (!(pe instanceof Leg)) continue;
                Leg leg = (Leg)pe;
                if (!this.plansConfigGroup.isRemovingUnneccessaryPlanAttributes() || leg.getRoute() == null) continue;
                leg.setTravelTime(Time.getUndefinedTime());
            }
        }
    }
}

