/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.algorithms;

import java.util.List;
import java.util.Random;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.population.PersonUtils;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.population.routes.NetworkRoute;

public final class ChooseRandomLegMode
implements PlanAlgorithm {
    private final String[] possibleModes;
    private boolean ignoreCarAvailability = true;
    private boolean allowSwitchFromListedModesOnly;
    private final Random rng;

    public ChooseRandomLegMode(String[] possibleModes, Random rng, boolean allowSwitchFromListedModesOnly) {
        this.possibleModes = (String[])possibleModes.clone();
        this.allowSwitchFromListedModesOnly = allowSwitchFromListedModesOnly;
        this.rng = rng;
    }

    public void setIgnoreCarAvailability(boolean ignoreCarAvailability) {
        this.ignoreCarAvailability = ignoreCarAvailability;
    }

    @Override
    public void run(Plan plan) {
        List<PlanElement> tour = plan.getPlanElements();
        this.changeToRandomLegMode(tour, plan);
    }

    private void changeToRandomLegMode(List<PlanElement> tour, Plan plan) {
        if (tour.size() > 1) {
            String newMode;
            block4: {
                String carAvail;
                boolean forbidCar = false;
                if (!this.ignoreCarAvailability && "never".equals(carAvail = PersonUtils.getCarAvail(plan.getPerson()))) {
                    forbidCar = true;
                }
                String currentMode = this.getTransportMode(tour);
                if (this.allowSwitchFromListedModesOnly && !this.contains(this.possibleModes, currentMode)) {
                    return;
                }
                do {
                    int newModeIdx = this.chooseModeOtherThan(currentMode);
                    newMode = this.possibleModes[newModeIdx];
                    if (!forbidCar || !"car".equals(newMode)) break block4;
                } while (this.possibleModes.length != 2);
                newMode = currentMode;
            }
            this.changeLegModeTo(tour, newMode);
        }
    }

    private <T> boolean contains(T[] array, T value) {
        for (T t : array) {
            if (!t.equals(value)) continue;
            return true;
        }
        return false;
    }

    private String getTransportMode(List<PlanElement> tour) {
        return ((Leg)tour.get(1)).getMode();
    }

    private void changeLegModeTo(List<PlanElement> tour, String newMode) {
        for (PlanElement pe : tour) {
            if (!(pe instanceof Leg)) continue;
            Leg leg = (Leg)pe;
            leg.setMode(newMode);
            Route route = leg.getRoute();
            if (!(route instanceof NetworkRoute)) continue;
            ((NetworkRoute)route).setVehicleId(null);
        }
    }

    private int chooseModeOtherThan(String currentMode) {
        int newModeIdx = this.rng.nextInt(this.possibleModes.length - 1);
        for (int i = 0; i <= newModeIdx; ++i) {
            if (!this.possibleModes[i].equals(currentMode)) continue;
            ++newModeIdx;
            break;
        }
        return newModeIdx;
    }
}

