/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.BasicLocation;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Identifiable;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.algorithms.ChooseRandomSingleLegMode;
import org.matsim.core.population.algorithms.PermissibleModesCalculator;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.population.algorithms.TripsToLegsAlgorithm;
import org.matsim.core.replanning.modules.SubtourModeChoice;
import org.matsim.core.router.MainModeIdentifier;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.TripStructureUtils;
import org.matsim.facilities.ActivityFacility;

public final class ChooseRandomLegModeForSubtour
implements PlanAlgorithm {
    private static Logger logger = Logger.getLogger(ChooseRandomLegModeForSubtour.class);
    private Collection<String> modes;
    private final Collection<String> chainBasedModes;
    private final SubtourModeChoice.Behavior behavior;
    private Collection<String> singleTripSubtourModes;
    private final StageActivityTypes stageActivityTypes;
    private final MainModeIdentifier mainModeIdentifier;
    private final Random rng;
    private PermissibleModesCalculator permissibleModesCalculator;
    private final double probaForChangeSingleTripMode;
    private TripsToLegsAlgorithm tripsToLegs = null;
    private ChooseRandomSingleLegMode changeSingleLegMode = null;

    public ChooseRandomLegModeForSubtour(StageActivityTypes stageActivityTypes, MainModeIdentifier mainModeIdentifier, PermissibleModesCalculator permissibleModesCalculator, String[] modes, String[] chainBasedModes, Random rng, SubtourModeChoice.Behavior behavior, double probaForChooseRandomSingleTripMode) {
        this.stageActivityTypes = stageActivityTypes;
        this.mainModeIdentifier = mainModeIdentifier;
        this.permissibleModesCalculator = permissibleModesCalculator;
        this.modes = Arrays.asList(modes);
        this.chainBasedModes = Arrays.asList(chainBasedModes);
        this.behavior = behavior;
        this.probaForChangeSingleTripMode = probaForChooseRandomSingleTripMode;
        this.singleTripSubtourModes = this.chainBasedModes;
        this.rng = rng;
        logger.info("Chain based modes: " + this.chainBasedModes.toString());
        if (this.probaForChangeSingleTripMode > 0.0) {
            ArrayList<String> notChainBasedModes = new ArrayList<String>(this.modes);
            notChainBasedModes.removeAll(this.chainBasedModes);
            String[] possibleModes = notChainBasedModes.toArray(new String[0]);
            if (possibleModes.length >= 2) {
                this.tripsToLegs = new TripsToLegsAlgorithm(this.stageActivityTypes, this.mainModeIdentifier);
                this.changeSingleLegMode = new ChooseRandomSingleLegMode(possibleModes, rng, true);
            }
        }
    }

    public void setSingleTripSubtourModes(String[] singleTripSubtourModes) {
        this.singleTripSubtourModes = Arrays.asList(singleTripSubtourModes);
    }

    @Override
    public void run(Plan plan) {
        if (plan.getPlanElements().size() <= 1) {
            return;
        }
        if (this.changeSingleLegMode != null && this.rng.nextDouble() < this.probaForChangeSingleTripMode) {
            this.tripsToLegs.run(plan);
            this.changeSingleLegMode.run(plan);
            return;
        }
        Id<Identifiable<ActivityFacility>> homeLocation = ((Activity)plan.getPlanElements().get(0)).getFacilityId() != null ? ((Activity)plan.getPlanElements().get(0)).getFacilityId() : ((Activity)plan.getPlanElements().get(0)).getLinkId();
        Collection<String> permissibleModesForThisPlan = this.permissibleModesCalculator.getPermissibleModes(plan);
        List<Candidate> choiceSet = this.determineChoiceSet(homeLocation, TripStructureUtils.getTrips(plan, this.stageActivityTypes), TripStructureUtils.getSubtours(plan, this.stageActivityTypes), permissibleModesForThisPlan);
        if (!choiceSet.isEmpty()) {
            Candidate whatToDo = choiceSet.get(this.rng.nextInt(choiceSet.size()));
            this.applyChange(whatToDo, plan);
        }
    }

    private List<Candidate> determineChoiceSet(Id<? extends BasicLocation> homeLocation, List<TripStructureUtils.Trip> trips, Collection<TripStructureUtils.Subtour> subtours, Collection<String> permissibleModesForThisPerson) {
        ArrayList<Candidate> choiceSet = new ArrayList<Candidate>();
        for (TripStructureUtils.Subtour subtour : subtours) {
            if (!subtour.isClosed() || this.containsUnknownMode(subtour)) continue;
            Id<Identifiable<ActivityFacility>> subtourStartLocation = subtour.getTrips().get(0).getOriginActivity().getFacilityId() != null ? subtour.getTrips().get(0).getOriginActivity().getFacilityId() : subtour.getTrips().get(0).getOriginActivity().getLinkId();
            Collection<String> testingModes = subtour.getTrips().size() == 1 ? this.singleTripSubtourModes : this.chainBasedModes;
            LinkedHashSet<String> usableChainBasedModes = new LinkedHashSet<String>();
            for (String mode : testingModes) {
                Id<? extends BasicLocation> vehicleLocation = homeLocation;
                Activity lastDestination = this.findLastDestinationOfMode(trips.subList(0, trips.indexOf(subtour.getTrips().get(0))), mode);
                if (lastDestination != null) {
                    vehicleLocation = this.getLocationId(lastDestination);
                }
                if (!vehicleLocation.equals(subtourStartLocation)) continue;
                usableChainBasedModes.add(mode);
            }
            LinkedHashSet<String> usableModes = new LinkedHashSet<String>();
            if (this.isMassConserving(subtour)) {
                for (String candidate : permissibleModesForThisPerson) {
                    if (this.chainBasedModes.contains(candidate)) {
                        if (!usableChainBasedModes.contains(candidate)) continue;
                        usableModes.add(candidate);
                        continue;
                    }
                    usableModes.add(candidate);
                }
            }
            usableModes.remove(this.getTransportMode(subtour));
            for (String transportMode : usableModes) {
                choiceSet.add(new Candidate(subtour, transportMode));
            }
        }
        return choiceSet;
    }

    private boolean containsUnknownMode(TripStructureUtils.Subtour subtour) {
        for (TripStructureUtils.Trip trip : subtour.getTrips()) {
            if (this.modes.contains(this.mainModeIdentifier.identifyMainMode(trip.getTripElements()))) continue;
            return true;
        }
        return false;
    }

    private boolean isMassConserving(TripStructureUtils.Subtour subtour) {
        for (String mode : this.chainBasedModes) {
            if (this.isMassConserving(subtour, mode)) continue;
            return false;
        }
        return true;
    }

    private boolean isMassConserving(TripStructureUtils.Subtour subtour, String mode) {
        Activity firstOrigin = this.findFirstOriginOfMode(subtour.getTrips(), mode);
        if (firstOrigin == null) {
            return true;
        }
        Activity lastDestination = this.findLastDestinationOfMode(subtour.getTrips(), mode);
        return this.atSameLocation(firstOrigin, lastDestination);
    }

    private Id<? extends BasicLocation> getLocationId(Activity activity) {
        return activity.getFacilityId() != null ? activity.getFacilityId() : activity.getLinkId();
    }

    private boolean atSameLocation(Activity firstLegUsingMode, Activity lastLegUsingMode) {
        return firstLegUsingMode.getFacilityId() != null ? firstLegUsingMode.getFacilityId().equals(lastLegUsingMode.getFacilityId()) : firstLegUsingMode.getLinkId().equals(lastLegUsingMode.getLinkId());
    }

    private Activity findLastDestinationOfMode(List<TripStructureUtils.Trip> tripsToSearch, String mode) {
        ArrayList<TripStructureUtils.Trip> reversed = new ArrayList<TripStructureUtils.Trip>(tripsToSearch);
        Collections.reverse(reversed);
        for (TripStructureUtils.Trip trip : reversed) {
            if (!mode.equals(this.mainModeIdentifier.identifyMainMode(trip.getTripElements()))) continue;
            return trip.getDestinationActivity();
        }
        return null;
    }

    private Activity findFirstOriginOfMode(List<TripStructureUtils.Trip> tripsToSearch, String mode) {
        for (TripStructureUtils.Trip trip : tripsToSearch) {
            if (!mode.equals(this.mainModeIdentifier.identifyMainMode(trip.getTripElements()))) continue;
            return trip.getOriginActivity();
        }
        return null;
    }

    private String getTransportMode(TripStructureUtils.Subtour subtour) {
        return this.mainModeIdentifier.identifyMainMode(subtour.getTrips().get(0).getTripElements());
    }

    private void applyChange(Candidate whatToDo, Plan plan) {
        for (TripStructureUtils.Trip trip : whatToDo.subtour.getTrips()) {
            if (this.behavior == SubtourModeChoice.Behavior.fromSpecifiedModesToSpecifiedModes && !this.modes.contains(this.mainModeIdentifier.identifyMainMode(trip.getTripElements()))) continue;
            TripRouter.insertTrip(plan, trip.getOriginActivity(), Collections.singletonList(PopulationUtils.createLeg(whatToDo.newTransportMode)), trip.getDestinationActivity());
        }
    }

    private static class Candidate {
        final TripStructureUtils.Subtour subtour;
        final String newTransportMode;

        public Candidate(TripStructureUtils.Subtour subtour, String newTransportMode) {
            this.subtour = subtour;
            this.newTransportMode = newTransportMode;
        }
    }
}

