/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.population.PersonUtils;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.population.routes.NetworkRoute;

public final class ChooseRandomSingleLegMode
implements PlanAlgorithm {
    private final String[] possibleModes;
    private boolean ignoreCarAvailability = true;
    private boolean allowSwitchFromListedModesOnly;
    private final Random rng;
    private final List<String> possibleFromModes = new ArrayList<String>();

    public ChooseRandomSingleLegMode(String[] possibleModes, Random rng, boolean allowSwitchFromListedModesOnly) {
        this.possibleModes = (String[])possibleModes.clone();
        this.allowSwitchFromListedModesOnly = allowSwitchFromListedModesOnly;
        if (allowSwitchFromListedModesOnly) {
            this.possibleFromModes.addAll(Arrays.asList(possibleModes));
        }
        this.rng = rng;
    }

    public void setIgnoreCarAvailability(boolean ignoreCarAvailability) {
        this.ignoreCarAvailability = ignoreCarAvailability;
    }

    @Override
    public void run(Plan plan) {
        String carAvail;
        boolean forbidCar = false;
        if (!this.ignoreCarAvailability && "never".equals(carAvail = PersonUtils.getCarAvail(plan.getPerson()))) {
            forbidCar = true;
        }
        ArrayList<Leg> legs = new ArrayList<Leg>();
        int cnt = 0;
        for (PlanElement pe : plan.getPlanElements()) {
            if (!(pe instanceof Leg)) continue;
            if (this.allowSwitchFromListedModesOnly) {
                if (!this.possibleFromModes.contains(((Leg)pe).getMode())) continue;
                legs.add((Leg)pe);
                ++cnt;
                continue;
            }
            legs.add((Leg)pe);
            ++cnt;
        }
        if (cnt == 0) {
            return;
        }
        int rndIdx = this.rng.nextInt(cnt);
        this.setRandomLegMode((Leg)legs.get(rndIdx), forbidCar);
    }

    private void setRandomLegMode(Leg leg, boolean forbidCar) {
        leg.setMode(this.chooseModeOtherThan(leg.getMode(), forbidCar));
        Route route = leg.getRoute();
        if (route != null && route instanceof NetworkRoute) {
            ((NetworkRoute)route).setVehicleId(null);
        }
    }

    private String chooseModeOtherThan(String currentMode, boolean forbidCar) {
        String newMode;
        block2: {
            do {
                int newModeIdx = this.rng.nextInt(this.possibleModes.length - 1);
                for (int i = 0; i <= newModeIdx; ++i) {
                    if (!this.possibleModes[i].equals(currentMode)) continue;
                    ++newModeIdx;
                    break;
                }
                newMode = this.possibleModes[newModeIdx];
                if (!forbidCar || !"car".equals(newMode)) break block2;
            } while (this.possibleModes.length != 2);
            newMode = currentMode;
        }
        return newMode;
    }
}

