/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.algorithms;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.population.algorithms.PersonAlgorithm;
import org.matsim.core.utils.misc.Counter;

public final class ParallelPersonAlgorithmUtils {
    private static final Logger log = Logger.getLogger(ParallelPersonAlgorithmUtils.class);

    private ParallelPersonAlgorithmUtils() {
    }

    public static void run(Population population, int numberOfThreads, final PersonAlgorithm algorithm) {
        ParallelPersonAlgorithmUtils.run(population, numberOfThreads, new PersonAlgorithmProvider(){

            @Override
            public PersonAlgorithm getPersonAlgorithm() {
                return algorithm;
            }
        });
    }

    public static void run(Population population, int numberOfThreads, PersonAlgorithmProvider algoProvider) {
        int i;
        int numOfThreads = Math.max(numberOfThreads, 1);
        PersonAlgoThread[] algoThreads = new PersonAlgoThread[numOfThreads];
        Thread[] threads = new Thread[numOfThreads];
        String name = null;
        Counter counter = null;
        AtomicBoolean hadException = new AtomicBoolean(false);
        ExceptionHandler uncaughtExceptionHandler = new ExceptionHandler(hadException);
        for (i = 0; i < numOfThreads; ++i) {
            Thread[] algo = algoProvider.getPersonAlgorithm();
            if (i == 0) {
                name = algo.getClass().getSimpleName();
                counter = new Counter("[" + name + "] handled person # ");
            }
            PersonAlgoThread personAlgoThread = new PersonAlgoThread((PersonAlgorithm)algo, counter);
            Thread thread = new Thread((Runnable)personAlgoThread, name + "." + i);
            thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            threads[i] = thread;
            algoThreads[i] = personAlgoThread;
        }
        i = 0;
        for (Person person : population.getPersons().values()) {
            algoThreads[i % numOfThreads].handlePerson(person);
            ++i;
        }
        for (Thread thread : threads) {
            thread.start();
        }
        try {
            for (Thread thread : threads) {
                thread.join();
            }
            counter.printCounter();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (hadException.get()) {
            throw new RuntimeException("Exception while processing persons. Cannot guarantee that all persons have been fully processed.");
        }
    }

    private static class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final AtomicBoolean hadException;

        public ExceptionHandler(AtomicBoolean hadException) {
            this.hadException = hadException;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("Thread " + t.getName() + " died with exception while handling events.", e);
            this.hadException.set(true);
        }
    }

    private static class PersonAlgoThread
    implements Runnable {
        private final PersonAlgorithm personAlgo;
        private final List<Person> persons = new LinkedList<Person>();
        private final Counter counter;

        public PersonAlgoThread(PersonAlgorithm algo, Counter counter) {
            this.personAlgo = algo;
            this.counter = counter;
        }

        public void handlePerson(Person person) {
            this.persons.add(person);
        }

        @Override
        public void run() {
            for (Person person : this.persons) {
                this.personAlgo.run(person);
                this.counter.incCounter();
            }
        }
    }

    public static interface PersonAlgorithmProvider {
        public PersonAlgorithm getPersonAlgorithm();
    }
}

