/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.core.population.PersonUtils;
import org.matsim.core.population.algorithms.PermissibleModesCalculator;

public final class PermissibleModesCalculatorImpl
implements PermissibleModesCalculator {
    private final List<String> availableModes;
    private final List<String> availableModesWithoutCar;
    private final boolean considerCarAvailability;

    public PermissibleModesCalculatorImpl(String[] availableModes, boolean considerCarAvailability) {
        this.availableModes = Arrays.asList(availableModes);
        if (this.availableModes.contains("car")) {
            ArrayList<String> l = new ArrayList<String>(this.availableModes);
            while (l.remove("car")) {
            }
            this.availableModesWithoutCar = Collections.unmodifiableList(l);
        } else {
            this.availableModesWithoutCar = this.availableModes;
        }
        this.considerCarAvailability = considerCarAvailability;
    }

    @Override
    public Collection<String> getPermissibleModes(Plan plan) {
        Person person;
        if (!this.considerCarAvailability) {
            return this.availableModes;
        }
        try {
            person = plan.getPerson();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("I need a PersonImpl to get car availability");
        }
        boolean carAvail = !"no".equals(PersonUtils.getLicense(person)) && !"never".equals(PersonUtils.getCarAvail(person));
        return carAvail ? this.availableModes : this.availableModesWithoutCar;
    }
}

