/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.algorithms;

import java.util.List;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.population.algorithms.AbstractPersonAlgorithm;
import org.matsim.core.utils.misc.Time;

public final class PersonCalcTimes
extends AbstractPersonAlgorithm {
    @Override
    public void run(Person person) {
        List plans = person.getPlans();
        for (int i = 0; i < plans.size(); ++i) {
            Plan plan = (Plan)plans.get(i);
            Activity act = null;
            Leg leg = null;
            int cnt = 0;
            int max = plan.getPlanElements().size();
            for (PlanElement pe : plan.getPlanElements()) {
                ++cnt;
                if (pe instanceof Activity) {
                    act = (Activity)pe;
                    if (cnt == 1) {
                        act.setStartTime(0.0);
                        act.setMaximumDuration(act.getEndTime());
                    } else if (cnt == max) {
                        double time = leg.getDepartureTime() + leg.getTravelTime();
                        act.setStartTime(time);
                        if (time < 86400.0) {
                            time = 86400.0;
                        }
                        act.setEndTime(time);
                        act.setMaximumDuration(time - act.getStartTime());
                    } else {
                        act.setStartTime(leg.getDepartureTime() + leg.getTravelTime());
                        act.setEndTime(act.getStartTime() + act.getMaximumDuration());
                    }
                }
                if (!(pe instanceof Leg)) continue;
                leg = (Leg)pe;
                leg.setDepartureTime(act.getEndTime());
                double ttime = leg.getTravelTime();
                if (Time.isUndefinedTime(ttime)) {
                    ttime = 0.0;
                }
                leg.setTravelTime(leg.getDepartureTime() + ttime - leg.getDepartureTime());
            }
        }
    }
}

