/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.algorithms;

import java.util.HashSet;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.algorithms.TransportModeNetworkFilter;
import org.matsim.core.population.algorithms.AbstractPersonAlgorithm;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.population.algorithms.XY2Links;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.facilities.ActivityFacilities;

public final class PersonPrepareForSim
extends AbstractPersonAlgorithm {
    private final PlanAlgorithm router;
    private final XY2Links xy2links;
    private final Network carOnlyNetwork;
    private final ActivityFacilities activityFacilities;
    private static final Logger log = Logger.getLogger(PersonPrepareForSim.class);
    private final Scenario scenario;

    public PersonPrepareForSim(PlanAlgorithm router, Scenario scenario, Network carOnlyNetwork) {
        this.router = router;
        this.carOnlyNetwork = carOnlyNetwork;
        if (NetworkUtils.isMultimodal(carOnlyNetwork)) {
            throw new RuntimeException("Expected carOnlyNetwork not to be multi-modal. Aborting!");
        }
        this.xy2links = new XY2Links(carOnlyNetwork, scenario.getActivityFacilities());
        this.activityFacilities = scenario.getActivityFacilities();
        this.scenario = scenario;
    }

    public PersonPrepareForSim(PlanAlgorithm router, Scenario scenario) {
        this.router = router;
        Network net = this.carOnlyNetwork = scenario.getNetwork();
        if (NetworkUtils.isMultimodal(this.carOnlyNetwork)) {
            log.info("Network seems to be multimodal. XY2Links will only use car links.");
            TransportModeNetworkFilter filter = new TransportModeNetworkFilter(this.carOnlyNetwork);
            net = NetworkUtils.createNetwork();
            HashSet<String> modes = new HashSet<String>();
            modes.add("car");
            filter.filter(net, modes);
        }
        this.xy2links = new XY2Links(net, scenario.getActivityFacilities());
        this.activityFacilities = scenario.getActivityFacilities();
        this.scenario = scenario;
    }

    @Override
    public void run(Person person) {
        Plan selectedPlan = (Plan)person.getSelectedPlan();
        if (selectedPlan == null) {
            log.warn("Person " + person.getId() + " has no plans!");
            return;
        }
        for (Plan plan : person.getPlans()) {
            boolean needsXY2Links = false;
            boolean needsReRoute = false;
            for (PlanElement pe : plan.getPlanElements()) {
                if (pe instanceof Activity) {
                    Activity act = (Activity)pe;
                    if (act.getLinkId() != null || act.getFacilityId() != null && !this.activityFacilities.getFacilities().isEmpty() && this.activityFacilities.getFacilities().get(act.getFacilityId()) != null && this.activityFacilities.getFacilities().get(act.getFacilityId()).getLinkId() != null) continue;
                    needsXY2Links = true;
                    needsReRoute = true;
                    break;
                }
                if (!(pe instanceof Leg)) continue;
                Leg leg = (Leg)pe;
                if (leg.getMode().equals("access_walk") || leg.getMode().equals("egress_walk")) {
                    leg.setMode("non_network_walk");
                }
                if (leg.getRoute() == null) {
                    needsReRoute = true;
                    continue;
                }
                if (!Double.isNaN(leg.getRoute().getDistance())) continue;
                Double dist = null;
                if (leg.getRoute() instanceof NetworkRoute) {
                    double relativePositionStartLink = 1.0;
                    double relativePositionEndLink = 1.0;
                    dist = RouteUtils.calcDistance((NetworkRoute)leg.getRoute(), relativePositionStartLink, relativePositionEndLink, this.scenario.getNetwork());
                }
                if (dist == null) continue;
                leg.getRoute().setDistance(dist);
            }
            if (needsXY2Links) {
                this.xy2links.run(plan);
            }
            if (!needsReRoute) continue;
            this.router.run(plan);
        }
    }
}

