/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.algorithms;

import java.util.List;
import java.util.Random;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.utils.misc.Time;

public final class PlanMutateTimeAllocation
implements PlanAlgorithm {
    private final double mutationRange;
    private final Random random;

    public PlanMutateTimeAllocation(double mutationRange, Random random) {
        this.mutationRange = mutationRange;
        this.random = random;
    }

    @Override
    public void run(Plan plan) {
        this.mutatePlan(plan);
    }

    private void mutatePlan(Plan plan) {
        List<PlanElement> planElements = plan.getPlanElements();
        int max = planElements.size();
        double now = 0.0;
        for (int i = 0; i < max; ++i) {
            PlanElement pe = planElements.get(i);
            if (pe instanceof Activity) {
                Activity act = (Activity)pe;
                if (i == 0) {
                    act.setStartTime(now);
                    act.setEndTime(this.mutateTime(act.getEndTime()));
                    act.setMaximumDuration(act.getEndTime() - act.getStartTime());
                    now += act.getEndTime();
                    continue;
                }
                if (i < max - 1) {
                    act.setStartTime(now);
                    if (!Time.isUndefinedTime(act.getMaximumDuration())) {
                        act.setMaximumDuration(this.mutateTime(act.getMaximumDuration()));
                        act.setEndTime(now += act.getMaximumDuration());
                        continue;
                    }
                    double newEndTime = this.mutateTime(act.getEndTime());
                    if (newEndTime < now) {
                        newEndTime = now;
                    }
                    act.setEndTime(newEndTime);
                    now = newEndTime;
                    continue;
                }
                act.setStartTime(now);
                act.setMaximumDuration(Time.getUndefinedTime());
                act.setEndTime(Time.getUndefinedTime());
                continue;
            }
            if (!(pe instanceof Leg)) continue;
            Leg leg = (Leg)pe;
            leg.setDepartureTime(now);
            if (!Time.isUndefinedTime(leg.getTravelTime())) {
                now += leg.getTravelTime();
            }
            double arrTime = now;
            leg.setTravelTime(arrTime - leg.getDepartureTime());
        }
    }

    private double mutateTime(double time) {
        double t = time;
        if (!Time.isUndefinedTime(t)) {
            if ((t += (double)((int)((this.random.nextDouble() * 2.0 - 1.0) * this.mutationRange))) < 0.0) {
                t = 0.0;
            }
            if (t > 86400.0) {
                t = 86400.0;
            }
        } else {
            t = this.random.nextInt(86400);
        }
        return t;
    }
}

