/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.algorithms;

import java.util.Random;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.router.EmptyStageActivityTypes;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.router.TripStructureUtils;
import org.matsim.core.utils.misc.Time;

public final class PlanMutateTimeAllocationSimplified
implements PlanAlgorithm {
    private final StageActivityTypes blackList;
    private final double mutationRange;
    private final Random random;
    private final boolean affectingDuration;

    public PlanMutateTimeAllocationSimplified(double mutationRange, boolean affectingDuration, Random random) {
        this(EmptyStageActivityTypes.INSTANCE, mutationRange, affectingDuration, random);
    }

    public PlanMutateTimeAllocationSimplified(StageActivityTypes blackList, double mutationRange, boolean affectingDuration, Random random) {
        this.blackList = blackList;
        this.mutationRange = mutationRange;
        this.affectingDuration = affectingDuration;
        this.random = random;
    }

    @Override
    public void run(Plan plan) {
        for (Activity act : TripStructureUtils.getActivities(plan, this.blackList)) {
            if (!Time.isUndefinedTime(act.getEndTime())) {
                act.setEndTime(this.mutateTime(act.getEndTime()));
            }
            if (!this.affectingDuration || Time.isUndefinedTime(act.getMaximumDuration())) continue;
            act.setMaximumDuration(this.mutateTime(act.getMaximumDuration()));
        }
    }

    private double mutateTime(double time) {
        double t = time;
        if ((t += (double)((int)((this.random.nextDouble() * 2.0 - 1.0) * this.mutationRange))) < 0.0) {
            t = 0.0;
        }
        return t;
    }
}

