/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.algorithms;

import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.population.PersonUtils;

public final class PlansFilterByLegMode {
    private static final Logger log = Logger.getLogger(PlansFilterByLegMode.class);
    private String legMode;
    private boolean legModeIsCar;
    public FilterType filterType;
    private static int cnt = 0;

    public PlansFilterByLegMode(String legMode, FilterType filterType) {
        this.legMode = legMode;
        this.filterType = filterType;
        this.legModeIsCar = legMode.equals("car");
    }

    public void run(Population plans) {
        int planCount = 0;
        System.out.println("    running " + this.getClass().getName() + " algorithm...");
        String never = "never";
        TreeSet<Id<Person>> pid_set = new TreeSet<Id<Person>>();
        for (Id<Person> personId : plans.getPersons().keySet()) {
            Person person = plans.getPersons().get(personId);
            for (int i = person.getPlans().size() - 1; i >= 0; --i) {
                Plan plan = (Plan)person.getPlans().get(i);
                boolean hasSearchedLegMode = false;
                boolean hasOtherLegMode = false;
                for (int j = 1; j < plan.getPlanElements().size(); j += 2) {
                    Leg leg = (Leg)plan.getPlanElements().get(j);
                    if (leg.getMode().equals(this.legMode)) {
                        hasSearchedLegMode = true;
                        continue;
                    }
                    hasOtherLegMode = true;
                }
                if (this.legModeIsCar && never.equals(PersonUtils.getCarAvail(person))) {
                    if (cnt < 1) {
                        ++cnt;
                        log.warn("This method assumes that mode=car without car availability means `in car as passenger'.  Note that this is different from what is often done in transport planning, where `in car as passenger' is a separate mode.");
                        log.warn(" This message given only once.");
                    }
                    hasSearchedLegMode = false;
                }
                if (this.filterType == FilterType.keepAllPlansWithMode || this.filterType == FilterType.keepPlansWithOnlyThisMode) {
                    if (hasSearchedLegMode && (!hasOtherLegMode || this.filterType != FilterType.keepPlansWithOnlyThisMode)) continue;
                    person.getPlans().remove(i);
                    --i;
                    ++planCount;
                    continue;
                }
                if (this.filterType == FilterType.removeAllPlansWithMode) {
                    if (!hasSearchedLegMode) continue;
                    person.getPlans().remove(i);
                    --i;
                    ++planCount;
                    continue;
                }
                throw new RuntimeException("should not happen;");
            }
            if (!person.getPlans().isEmpty()) continue;
            pid_set.add(personId);
        }
        for (Id<Person> pid : pid_set) {
            plans.getPersons().remove(pid);
        }
        System.out.println("    done.");
        System.out.println("Number of plans removed:   " + planCount);
        System.out.println("Number of persons removed: " + pid_set.size());
    }

    public static enum FilterType {
        keepAllPlansWithMode,
        removeAllPlansWithMode,
        keepPlansWithOnlyThisMode;

    }
}

