/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.algorithms;

import java.util.Map;
import java.util.Random;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.utils.misc.Time;

public final class TripPlanMutateTimeAllocation
implements PlanAlgorithm {
    private final StageActivityTypes stageActivities;
    private final double mutationRange;
    private final Random random;
    private boolean useActivityDurations = true;
    private final boolean affectingDuration;
    private final String subpopulationAttribute;
    private final Map<String, Double> subpopulationMutationRanges;
    private final Map<String, Boolean> subpopulationAffectingDuration;

    public TripPlanMutateTimeAllocation(StageActivityTypes stageActivities, double mutationRange, boolean affectingDuration, Random random) {
        this(stageActivities, mutationRange, affectingDuration, random, null, null, null);
    }

    public TripPlanMutateTimeAllocation(StageActivityTypes stageActivities, double mutationRange, boolean affectingDuration, Random random, String subpopulationAttribute, Map<String, Double> subpopulationMutationRanges, Map<String, Boolean> subpopulationAffectingDuration) {
        this.stageActivities = stageActivities;
        this.mutationRange = mutationRange;
        this.affectingDuration = affectingDuration;
        this.random = random;
        this.subpopulationAttribute = subpopulationAttribute;
        this.subpopulationMutationRanges = subpopulationMutationRanges;
        this.subpopulationAffectingDuration = subpopulationAffectingDuration;
    }

    @Override
    public void run(Plan plan) {
        this.mutatePlan(plan);
    }

    private void mutatePlan(Plan plan) {
        double now = 0.0;
        boolean isFirst = true;
        Activity lastAct = (Activity)plan.getPlanElements().listIterator(plan.getPlanElements().size()).previous();
        String subpopulation = this.getSubpopulation(plan);
        boolean affectingDuration = this.isAffectingDuration(subpopulation);
        double mutationRange = this.getMutationRange(subpopulation);
        for (PlanElement pe : plan.getPlanElements()) {
            if (pe instanceof Activity) {
                Activity act = (Activity)pe;
                if (isFirst) {
                    isFirst = false;
                    act.setStartTime(now);
                    act.setEndTime(this.mutateTime(act.getEndTime(), mutationRange));
                    if (affectingDuration) {
                        act.setMaximumDuration(act.getEndTime() - act.getStartTime());
                    }
                    now += act.getEndTime();
                    continue;
                }
                if (act != lastAct) {
                    double newEndTime;
                    act.setStartTime(now);
                    if (this.stageActivities.isStageActivity(act.getType())) continue;
                    if (this.useActivityDurations) {
                        if (!Time.isUndefinedTime(act.getMaximumDuration())) {
                            if (affectingDuration) {
                                act.setMaximumDuration(this.mutateTime(act.getMaximumDuration(), mutationRange));
                            }
                            act.setEndTime(now += act.getMaximumDuration());
                            continue;
                        }
                        newEndTime = this.mutateTime(act.getEndTime(), mutationRange);
                        if (newEndTime < now) {
                            newEndTime = now;
                        }
                        act.setEndTime(newEndTime);
                        now = newEndTime;
                        continue;
                    }
                    if (Time.isUndefinedTime(act.getEndTime())) {
                        throw new IllegalStateException("Can not mutate activity end time because it is not set for Person: " + plan.getPerson().getId());
                    }
                    newEndTime = this.mutateTime(act.getEndTime(), mutationRange);
                    if (newEndTime < now) {
                        newEndTime = now;
                    }
                    act.setEndTime(newEndTime);
                    now = newEndTime;
                    continue;
                }
                act.setStartTime(now);
                act.setMaximumDuration(Time.getUndefinedTime());
                act.setEndTime(Time.getUndefinedTime());
                continue;
            }
            Leg leg = (Leg)pe;
            leg.setDepartureTime(now);
            if (!Time.isUndefinedTime(leg.getTravelTime())) {
                now += leg.getTravelTime();
            }
            double arrTime = now;
            leg.setTravelTime(arrTime - leg.getDepartureTime());
        }
    }

    private double mutateTime(double time, double mutationRange) {
        double t = time;
        if (!Time.isUndefinedTime(t)) {
            if ((t += (double)((int)((this.random.nextDouble() * 2.0 - 1.0) * mutationRange))) < 0.0) {
                t = 0.0;
            }
            if (t > 86400.0) {
                t = 86400.0;
            }
        } else {
            t = this.random.nextInt(86400);
        }
        return t;
    }

    public void setUseActivityDurations(boolean useActivityDurations) {
        this.useActivityDurations = useActivityDurations;
    }

    private final String getSubpopulation(Plan plan) {
        if (this.subpopulationAttribute == null) {
            return null;
        }
        if (plan.getPerson() == null) {
            return null;
        }
        return (String)PopulationUtils.getPersonAttribute(plan.getPerson(), this.subpopulationAttribute);
    }

    private final boolean isAffectingDuration(String subpopulation) {
        Boolean isAffectingDuration;
        if (subpopulation != null && (isAffectingDuration = this.subpopulationAffectingDuration.get(subpopulation)) != null) {
            return isAffectingDuration;
        }
        return this.affectingDuration;
    }

    private final double getMutationRange(String subpopulation) {
        Double mutationRange;
        if (subpopulation != null && (mutationRange = this.subpopulationMutationRanges.get(subpopulation)) != null) {
            return mutationRange;
        }
        return this.mutationRange;
    }
}

