/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.algorithms;

import java.util.List;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.router.MainModeIdentifier;
import org.matsim.core.router.StageActivityTypes;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.TripStructureUtils;

public final class TripsToLegsAlgorithm
implements PlanAlgorithm {
    private final StageActivityTypes blackList;
    private final MainModeIdentifier mainModeIdentifier;

    public TripsToLegsAlgorithm(TripRouter router) {
        this(router.getStageActivityTypes(), router.getMainModeIdentifier());
    }

    public TripsToLegsAlgorithm(StageActivityTypes blackList, MainModeIdentifier mainModeIdentifier) {
        this.blackList = blackList;
        this.mainModeIdentifier = mainModeIdentifier;
    }

    @Override
    public void run(Plan plan) {
        List<PlanElement> planElements = plan.getPlanElements();
        List<TripStructureUtils.Trip> trips = TripStructureUtils.getTrips(plan, this.blackList);
        for (TripStructureUtils.Trip trip : trips) {
            List<PlanElement> fullTrip = planElements.subList(planElements.indexOf(trip.getOriginActivity()) + 1, planElements.indexOf(trip.getDestinationActivity()));
            String mode = this.mainModeIdentifier.identifyMainMode(fullTrip);
            fullTrip.clear();
            fullTrip.add(PopulationUtils.createLeg(mode));
            if (fullTrip.size() == 1) continue;
            throw new RuntimeException(fullTrip.toString());
        }
    }
}

