/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.algorithms;

import java.util.List;
import java.util.Objects;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.population.algorithms.AbstractPersonAlgorithm;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.ActivityFacility;

public final class XY2Links
extends AbstractPersonAlgorithm
implements PlanAlgorithm {
    private final Network network;
    private final ActivityFacilities activityFacilities;

    public XY2Links(Network network, ActivityFacilities activityFacilities) {
        this.network = network;
        this.activityFacilities = activityFacilities;
    }

    public XY2Links(Scenario scenario) {
        this(scenario.getNetwork(), scenario.getActivityFacilities());
    }

    @Override
    public void run(Person person) {
        for (Plan plan : person.getPlans()) {
            this.processPlan(plan);
        }
    }

    @Override
    public void run(Plan plan) {
        this.processPlan(plan);
    }

    private void processPlan(Plan plan) {
        Objects.requireNonNull(this.activityFacilities);
        List<PlanElement> planElements = plan.getPlanElements();
        for (PlanElement planElement : planElements) {
            Link link;
            if (!(planElement instanceof Activity)) continue;
            Activity act = (Activity)planElement;
            if (this.activityFacilities != null) {
                // empty if block
            }
            if (act.getLinkId() != null) continue;
            if (act.getCoord() == null) {
                Gbl.assertNotNull(act.getFacilityId());
                ActivityFacility activityFacility = this.activityFacilities.getFacilities().get(act.getFacilityId());
                Gbl.assertNotNull(activityFacility);
                act.setCoord(activityFacility.getCoord());
            }
            if (null == (link = NetworkUtils.getNearestLink(this.network, act.getCoord()))) {
                throw new RuntimeException("For person id=" + plan.getPerson().getId() + ": getNearestLink returned Null! act=" + act);
            }
            act.setLinkId(link.getId());
        }
    }
}

