/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.io;

import java.io.BufferedWriter;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.population.PersonUtils;
import org.matsim.core.population.io.PopulationWriterHandler;

abstract class AbstractPopulationWriterHandler
implements PopulationWriterHandler {
    private static final Logger log = Logger.getLogger(AbstractPopulationWriterHandler.class);

    AbstractPopulationWriterHandler() {
    }

    @Override
    public final void writePerson(Person person, BufferedWriter writer) throws IOException {
        this.startPerson(person, writer);
        if (PersonUtils.getTravelcards(person) != null) {
            for (String t : PersonUtils.getTravelcards(person)) {
                this.startTravelCard(t, writer);
                this.endTravelCard(writer);
            }
        }
        for (Plan plan : person.getPlans()) {
            this.startPlan(plan, writer);
            for (PlanElement pe : plan.getPlanElements()) {
                if (pe instanceof Activity) {
                    Activity act = (Activity)pe;
                    this.startAct(act, writer);
                    this.endAct(writer);
                    continue;
                }
                if (!(pe instanceof Leg)) continue;
                Leg leg = (Leg)pe;
                this.startLeg(leg, writer);
                Route route = leg.getRoute();
                if (route != null) {
                    this.startRoute(route, writer);
                    this.endRoute(writer);
                }
                this.endLeg(writer);
            }
            this.endPlan(writer);
        }
        this.endPerson(writer);
        this.writeSeparator(writer);
        writer.flush();
    }

    public abstract void startPerson(Person var1, BufferedWriter var2) throws IOException;

    public abstract void endPerson(BufferedWriter var1) throws IOException;

    public abstract void startTravelCard(String var1, BufferedWriter var2) throws IOException;

    public abstract void endTravelCard(BufferedWriter var1) throws IOException;

    public abstract void startPlan(Plan var1, BufferedWriter var2) throws IOException;

    public abstract void endPlan(BufferedWriter var1) throws IOException;

    public abstract void startAct(Activity var1, BufferedWriter var2) throws IOException;

    public abstract void endAct(BufferedWriter var1) throws IOException;

    public abstract void startLeg(Leg var1, BufferedWriter var2) throws IOException;

    public abstract void endLeg(BufferedWriter var1) throws IOException;

    public abstract void startRoute(Route var1, BufferedWriter var2) throws IOException;

    public abstract void endRoute(BufferedWriter var1) throws IOException;
}

