/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.io;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.config.Config;
import org.matsim.core.population.io.ParallelPopulationReaderMatsimV4Runner;
import org.matsim.core.population.io.PopulationReaderMatsimV4;
import org.matsim.core.population.io.StreamingPopulationReader;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.households.Households;
import org.matsim.lanes.Lanes;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.utils.objectattributes.attributable.Attributes;
import org.matsim.vehicles.Vehicles;
import org.xml.sax.helpers.AttributesImpl;

class ParallelPopulationReaderMatsimV4
extends PopulationReaderMatsimV4 {
    static final Logger log = Logger.getLogger(ParallelPopulationReaderMatsimV4.class);
    private final boolean isPopulationStreaming;
    private final int numThreads;
    private final BlockingQueue<List<Tag>> queue;
    private final CollectorScenario collectorScenario;
    private final CollectorPopulation collectorPopulation;
    private Thread[] threads;
    private List<Tag> currentPersonXmlData;
    private final CoordinateTransformation coordinateTransformation;

    public ParallelPopulationReaderMatsimV4(Scenario scenario) {
        this(new IdentityTransformation(), scenario);
    }

    public ParallelPopulationReaderMatsimV4(CoordinateTransformation coordinateTransformation, Scenario scenario) {
        super(coordinateTransformation, scenario);
        this.coordinateTransformation = coordinateTransformation;
        if (scenario.getPopulation() instanceof StreamingPopulationReader.StreamingPopulation) {
            log.warn("Population streaming is activated - cannot use " + ParallelPopulationReaderMatsimV4.class.getName() + "!");
            this.isPopulationStreaming = true;
            this.numThreads = 1;
            this.queue = null;
            this.collectorPopulation = null;
            this.collectorScenario = null;
        } else {
            this.isPopulationStreaming = false;
            this.numThreads = scenario.getConfig().global().getNumberOfThreads() > 0 ? scenario.getConfig().global().getNumberOfThreads() : 1;
            this.queue = new LinkedBlockingQueue<List<Tag>>();
            this.collectorPopulation = new CollectorPopulation(this.plans);
            this.collectorScenario = new CollectorScenario(scenario, this.collectorPopulation);
        }
    }

    private void initThreads() {
        this.threads = new Thread[this.numThreads];
        for (int i = 0; i < this.numThreads; ++i) {
            ParallelPopulationReaderMatsimV4Runner runner = new ParallelPopulationReaderMatsimV4Runner(this.coordinateTransformation, this.collectorScenario, this.queue);
            Thread thread = new Thread(runner);
            thread.setDaemon(true);
            thread.setName(ParallelPopulationReaderMatsimV4Runner.class.toString() + i);
            this.threads[i] = thread;
            thread.start();
        }
    }

    @Override
    public void startTag(String name, org.xml.sax.Attributes atts, Stack<String> context) {
        if (this.isPopulationStreaming) {
            super.startTag(name, atts, context);
            return;
        }
        if ("plans".equals(name)) {
            log.info("Start parallel population reading...");
            this.initThreads();
            this.startPlans(atts);
        } else {
            if ("person".equals(name)) {
                Person person = this.plans.getFactory().createPerson(Id.create(atts.getValue("id"), Person.class));
                this.currentPersonXmlData = new ArrayList<Tag>();
                PersonTag personTag = new PersonTag();
                personTag.person = person;
                this.currentPersonXmlData.add(personTag);
                this.plans.addPerson(person);
            }
            StartTag tag = new StartTag();
            tag.name = name;
            tag.atts = new AttributesImpl(atts);
            this.currentPersonXmlData.add(tag);
        }
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if (this.isPopulationStreaming) {
            super.endTag(name, content, context);
            return;
        }
        if ("plans".equals(name)) {
            for (int i = 0; i < this.numThreads; ++i) {
                ArrayList<EndProcessingTag> list = new ArrayList<EndProcessingTag>();
                list.add(new EndProcessingTag());
                this.queue.add(list);
            }
            try {
                for (Thread thread : this.threads) {
                    thread.join();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            super.endTag(name, content, context);
            log.info("Finished parallel population reading...");
        } else {
            EndTag tag = new EndTag();
            tag.name = name;
            tag.content = content;
            tag.context = context;
            this.currentPersonXmlData.add(tag);
            if ("person".equals(name)) {
                this.queue.add(this.currentPersonXmlData);
            }
        }
    }

    public final class EndProcessingTag
    extends Tag {
    }

    public final class EndTag
    extends Tag {
        String content;
    }

    public final class PersonTag
    extends Tag {
        Person person;
    }

    public final class StartTag
    extends Tag {
        org.xml.sax.Attributes atts;
    }

    public static abstract class Tag {
        String name;
        Stack<String> context = null;
    }

    private static class CollectorPopulation
    implements Population {
        private final Population population;

        public CollectorPopulation(Population population) {
            this.population = population;
        }

        @Override
        public PopulationFactory getFactory() {
            return this.population.getFactory();
        }

        @Override
        public String getName() {
            throw new RuntimeException("Calls to this method are not expected to happen...");
        }

        @Override
        public void setName(String name) {
            throw new RuntimeException("Calls to this method are not expected to happen...");
        }

        @Override
        public Map<Id<Person>, ? extends Person> getPersons() {
            throw new RuntimeException("Calls to this method are not expected to happen...");
        }

        @Override
        public void addPerson(Person p) {
            throw new RuntimeException("Calls to this method are not expected to happen...");
        }

        @Override
        public Person removePerson(Id<Person> personId) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public Attributes getAttributes() {
            throw new RuntimeException("Calls to this method are not expected to happen...");
        }
    }

    private static class CollectorScenario
    implements Scenario {
        private final Scenario delegate;
        private final CollectorPopulation population;

        public CollectorScenario(Scenario scenario, CollectorPopulation population) {
            this.delegate = scenario;
            this.population = population;
        }

        @Override
        public Network getNetwork() {
            return this.delegate.getNetwork();
        }

        @Override
        public Population getPopulation() {
            return this.population;
        }

        @Override
        public ActivityFacilities getActivityFacilities() {
            return this.delegate.getActivityFacilities();
        }

        @Override
        public TransitSchedule getTransitSchedule() {
            return this.delegate.getTransitSchedule();
        }

        @Override
        public Config getConfig() {
            return this.delegate.getConfig();
        }

        @Override
        public void addScenarioElement(String name, Object o) {
            this.delegate.addScenarioElement(name, o);
        }

        @Override
        public Object getScenarioElement(String name) {
            return this.delegate.getScenarioElement(name);
        }

        @Override
        public Vehicles getTransitVehicles() {
            return this.delegate.getTransitVehicles();
        }

        @Override
        public Households getHouseholds() {
            return this.delegate.getHouseholds();
        }

        @Override
        public Lanes getLanes() {
            return this.delegate.getLanes();
        }

        @Override
        public Vehicles getVehicles() {
            return this.delegate.getVehicles();
        }
    }
}

