/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.io;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.matsim.api.core.v01.Scenario;
import org.matsim.core.population.PersonUtils;
import org.matsim.core.population.io.ParallelPopulationReaderMatsimV4;
import org.matsim.core.population.io.PopulationReaderMatsimV4;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.xml.sax.Attributes;

class ParallelPopulationReaderMatsimV4Runner
extends PopulationReaderMatsimV4
implements Runnable {
    private final BlockingQueue<List<ParallelPopulationReaderMatsimV4.Tag>> queue;

    public ParallelPopulationReaderMatsimV4Runner(CoordinateTransformation coordinateTransformation, Scenario scenario, BlockingQueue<List<ParallelPopulationReaderMatsimV4.Tag>> queue) {
        super(coordinateTransformation, scenario);
        this.queue = queue;
    }

    @Override
    public void run() {
        try {
            block2: while (true) {
                List<ParallelPopulationReaderMatsimV4.Tag> tags = this.queue.take();
                Iterator<ParallelPopulationReaderMatsimV4.Tag> iterator = tags.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    ParallelPopulationReaderMatsimV4.Tag tag = iterator.next();
                    if (tag instanceof ParallelPopulationReaderMatsimV4.PersonTag) {
                        this.currperson = ((ParallelPopulationReaderMatsimV4.PersonTag)tag).person;
                        continue;
                    }
                    if (tag instanceof ParallelPopulationReaderMatsimV4.StartTag) {
                        if ("person".equals(tag.name)) {
                            this.startPerson(((ParallelPopulationReaderMatsimV4.StartTag)tag).atts);
                            continue;
                        }
                        this.startTag(tag.name, ((ParallelPopulationReaderMatsimV4.StartTag)tag).atts, tag.context);
                        continue;
                    }
                    if (tag instanceof ParallelPopulationReaderMatsimV4.EndTag) {
                        if ("person".equals(tag.name)) {
                            this.currperson = null;
                            continue;
                        }
                        this.endTag(tag.name, ((ParallelPopulationReaderMatsimV4.EndTag)tag).content, tag.context);
                        continue;
                    }
                    if (tag instanceof ParallelPopulationReaderMatsimV4.EndProcessingTag) break block2;
                }
                break;
            }
            return;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void startPerson(Attributes atts) {
        String ageString = atts.getValue("age");
        Integer age = null;
        if (ageString != null) {
            age = Integer.parseInt(ageString);
        }
        PersonUtils.setAge(this.currperson, age);
        PersonUtils.setSex(this.currperson, atts.getValue("sex"));
        PersonUtils.setLicence(this.currperson, atts.getValue("license"));
        PersonUtils.setCarAvail(this.currperson, atts.getValue("car_avail"));
        String employed = atts.getValue("employed");
        if (employed == null) {
            PersonUtils.setEmployed(this.currperson, null);
        } else {
            PersonUtils.setEmployed(this.currperson, "yes".equals(employed));
        }
    }
}

