/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.io;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Scenario;
import org.matsim.core.population.io.ParallelPopulationReaderMatsimV4;
import org.matsim.core.population.io.PopulationReaderMatsimV0;
import org.matsim.core.population.io.PopulationReaderMatsimV1;
import org.matsim.core.population.io.PopulationReaderMatsimV5;
import org.matsim.core.population.io.PopulationReaderMatsimV6;
import org.matsim.core.population.io.StreamingPopulationReader;
import org.matsim.core.scenario.ProjectionUtils;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.geometry.transformations.TransformationFactory;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class PopulationReader
extends MatsimXmlParser {
    private static final String PLANS = "plans.dtd";
    private static final String PLANS_V0 = "plans_v0.dtd";
    private static final String PLANS_V1 = "plans_v1.dtd";
    private static final String PLANS_V4 = "plans_v4.dtd";
    private static final String POPULATION_V5 = "population_v5.dtd";
    private static final String POPULATION_V6 = "population_v6.dtd";
    private final String inputCRS;
    private final String targetCRS;
    private MatsimXmlParser delegate = null;
    private final Scenario scenario;
    private Map<Class<?>, AttributeConverter<?>> attributeConverters = new HashMap();
    private static final Logger log = Logger.getLogger(PopulationReader.class);

    public PopulationReader(Scenario scenario) {
        this(null, null, scenario);
    }

    public PopulationReader(String inputCRS, String targetCRS, Scenario scenario) {
        this(inputCRS, targetCRS, scenario, false);
    }

    PopulationReader(String inputCRS, String targetCRS, Scenario scenario, boolean streaming) {
        if (!streaming && scenario.getPopulation() instanceof StreamingPopulationReader.StreamingPopulation) {
            throw new RuntimeException("MatsimPopulationReader called directly with an instance of StreamingPopulation in scenario.  Call via StreamingPopulationReader or ask for help.  kai, jul'16");
        }
        this.inputCRS = inputCRS;
        this.targetCRS = targetCRS;
        this.scenario = scenario;
    }

    public void putAttributeConverter(Class<?> clazz, AttributeConverter<?> converter) {
        this.attributeConverters.put(clazz, converter);
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.attributeConverters.putAll(converters);
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        this.delegate.startTag(name, atts, context);
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        this.delegate.endTag(name, content, context);
    }

    @Override
    protected void setDoctype(String doctype) {
        super.setDoctype(doctype);
        IdentityTransformation transformation = this.inputCRS == null ? new IdentityTransformation() : TransformationFactory.getCoordinateTransformation(this.inputCRS, this.targetCRS);
        switch (doctype) {
            case "population_v6.dtd": {
                this.delegate = new PopulationReaderMatsimV6(this.inputCRS, this.targetCRS, this.scenario);
                ((PopulationReaderMatsimV6)this.delegate).putAttributeConverters(this.attributeConverters);
                log.info("using population_v6-reader.");
                break;
            }
            case "population_v5.dtd": {
                this.delegate = new PopulationReaderMatsimV5(transformation, this.scenario);
                log.info("using population_v5-reader.");
                break;
            }
            case "plans_v4.dtd": {
                this.delegate = new ParallelPopulationReaderMatsimV4(transformation, this.scenario);
                log.info("using plans_v4-reader.");
                break;
            }
            case "plans_v1.dtd": {
                this.delegate = new PopulationReaderMatsimV1(transformation, this.scenario);
                log.info("using plans_v1-reader.");
                break;
            }
            case "plans_v0.dtd": 
            case "plans.dtd": {
                this.delegate = new PopulationReaderMatsimV0(transformation, this.scenario);
                log.info("using plans_v0-reader.");
                break;
            }
            default: {
                throw new IllegalArgumentException("No population reader available for doctype \"" + doctype + "\".");
            }
        }
    }

    @Override
    public void endDocument() {
        try {
            this.delegate.endDocument();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        if (this.targetCRS != null) {
            ProjectionUtils.putCRS(this.scenario.getPopulation(), this.targetCRS);
        }
    }
}

