/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.io;

import java.util.Locale;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.api.internal.MatsimReader;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.population.PersonUtils;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.core.utils.misc.Time;
import org.xml.sax.Attributes;

class PopulationReaderMatsimV0
extends MatsimXmlParser
implements MatsimReader {
    private static final String PLANS = "plans";
    private static final String DEMAND = "demand";
    private static final String SEGMENT = "segment";
    private static final String MODEL = "model";
    private static final String PARAM = "param";
    private static final String PERSON = "person";
    private static final String PLAN = "plan";
    private static final String ACT = "act";
    private static final String LEG = "leg";
    private static final String ROUTE = "route";
    private static final String ATTR_X100 = "x100";
    private static final String ATTR_Y100 = "y100";
    private final CoordinateTransformation coordinateTransformation;
    private final Population plans;
    private final Network network;
    private Person currperson = null;
    private Plan currplan = null;
    private Leg currleg = null;
    private NetworkRoute currroute = null;
    private Activity prevAct = null;
    private String routeNodes = null;
    private static final Logger log = Logger.getLogger(PopulationReaderMatsimV0.class);

    protected PopulationReaderMatsimV0(Scenario scenario) {
        this(new IdentityTransformation(), scenario);
    }

    protected PopulationReaderMatsimV0(CoordinateTransformation coordinateTransformation, Scenario scenario) {
        this.coordinateTransformation = coordinateTransformation;
        this.plans = scenario.getPopulation();
        this.network = scenario.getNetwork();
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        if (PERSON.equals(name)) {
            this.startPerson(atts);
        } else if (PLAN.equals(name)) {
            this.startPlan(atts);
        } else if (ACT.equals(name)) {
            this.startAct(atts);
        } else if (LEG.equals(name)) {
            this.startLeg(atts);
        } else if (ROUTE.equals(name)) {
            this.startRoute();
        } else if (DEMAND.equals(name)) {
            log.info("The tag <demand> is not supported");
        } else if (!(SEGMENT.equals(name) || MODEL.equals(name) || PARAM.equals(name) || PLANS.equals(name))) {
            throw new RuntimeException(this + "[tag=" + name + " not known or not supported]");
        }
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if (PERSON.equals(name)) {
            this.plans.addPerson(this.currperson);
            this.currperson = null;
        } else if (PLAN.equals(name)) {
            this.currplan = null;
        } else if (LEG.equals(name)) {
            this.currleg = null;
        } else if (ROUTE.equals(name)) {
            this.routeNodes = content;
        }
    }

    private void startPerson(Attributes atts) {
        this.currperson = this.plans.getFactory().createPerson(Id.create(atts.getValue("id"), Person.class));
    }

    private void startPlan(Attributes atts) {
        boolean selected;
        String sel = atts.getValue("selected");
        if (sel.equals("yes")) {
            selected = true;
        } else if (sel.equals("no")) {
            selected = false;
        } else {
            throw new NumberFormatException("Attribute 'selected' of Element 'Plan' is neither 'yes' nor 'no'.");
        }
        this.currplan = PersonUtils.createAndAddPlan(this.currperson, selected);
        this.routeNodes = null;
        String scoreString = atts.getValue("score");
        if (scoreString != null) {
            double score = Double.parseDouble(scoreString);
            this.currplan.setScore(score);
        }
    }

    private void startAct(Attributes atts) {
        Activity act;
        if (atts.getValue("zone") != null) {
            log.info("The attribute 'zone' of <act> will be ignored");
        }
        if (atts.getValue("link") != null) {
            Id<Link> linkId;
            Id<Link> linkId1 = linkId = Id.create(atts.getValue("link"), Link.class);
            act = PopulationUtils.createAndAddActivityFromLinkId(this.currplan, atts.getValue("type"), linkId1);
            if (atts.getValue(ATTR_X100) != null && atts.getValue(ATTR_Y100) != null) {
                Coord coord = this.parseCoord(atts);
                act.setCoord(coord);
            }
        } else if (atts.getValue(ATTR_X100) != null && atts.getValue(ATTR_Y100) != null) {
            Coord coord = this.parseCoord(atts);
            act = PopulationUtils.createAndAddActivityFromCoord(this.currplan, atts.getValue("type"), coord);
        } else {
            throw new IllegalArgumentException("Either the coords or the link must be specified for an Act.");
        }
        act.setStartTime(Time.parseTime(atts.getValue("start_time")));
        act.setMaximumDuration(Time.parseTime(atts.getValue("dur")));
        act.setEndTime(Time.parseTime(atts.getValue("end_time")));
        if (this.routeNodes != null) {
            this.currroute.setLinkIds(this.prevAct.getLinkId(), NetworkUtils.getLinkIds(RouteUtils.getLinksFromNodes(NetworkUtils.getNodes(this.network, this.routeNodes))), act.getLinkId());
            this.routeNodes = null;
            this.currroute = null;
        }
        this.prevAct = act;
    }

    private Coord parseCoord(Attributes atts) {
        return this.coordinateTransformation.transform(new Coord(Double.parseDouble(atts.getValue(ATTR_X100)), Double.parseDouble(atts.getValue(ATTR_Y100))));
    }

    private void startLeg(Attributes atts) {
        this.currleg = PopulationUtils.createAndAddLeg(this.currplan, atts.getValue("mode").toLowerCase(Locale.ROOT).intern());
        this.currleg.setDepartureTime(Time.parseTime(atts.getValue("dep_time")));
        this.currleg.setTravelTime(Time.parseTime(atts.getValue("trav_time")));
    }

    private void startRoute() {
        this.currroute = this.plans.getFactory().getRouteFactories().createRoute(NetworkRoute.class, this.prevAct.getLinkId(), this.prevAct.getLinkId());
        this.currleg.setRoute(this.currroute);
    }
}

