/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.io;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Stack;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.api.internal.MatsimReader;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.population.PersonUtils;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.core.utils.misc.Time;
import org.xml.sax.Attributes;

class PopulationReaderMatsimV1
extends MatsimXmlParser
implements MatsimReader {
    private static final String PLANS = "plans";
    private static final String PERSON = "person";
    private static final String PLAN = "plan";
    private static final String ACT = "act";
    private static final String LEG = "leg";
    private static final String ROUTE = "route";
    private static final String ATTR_X100 = "x100";
    private static final String ATTR_Y100 = "y100";
    private final CoordinateTransformation coordinateTransformation;
    private final Population plans;
    private final Network network;
    private Person currperson = null;
    private Plan currplan = null;
    private Leg currleg = null;
    private NetworkRoute currroute = null;
    private String routeNodes = null;
    private Activity prevAct = null;

    public PopulationReaderMatsimV1(Scenario scenario) {
        this(new IdentityTransformation(), scenario);
    }

    public PopulationReaderMatsimV1(CoordinateTransformation coordinateTransformation, Scenario scenario) {
        this.coordinateTransformation = coordinateTransformation;
        this.plans = scenario.getPopulation();
        this.network = scenario.getNetwork();
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        if (PLANS.equals(name)) {
            this.startPlans(atts);
        } else if (PERSON.equals(name)) {
            this.startPerson(atts);
        } else if (PLAN.equals(name)) {
            this.startPlan(atts);
        } else if (ACT.equals(name)) {
            this.startAct(atts);
        } else if (LEG.equals(name)) {
            this.startLeg(atts);
        } else if (ROUTE.equals(name)) {
            this.startRoute(atts);
        } else {
            throw new RuntimeException(this + "[tag=" + name + " not known or not supported]");
        }
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if (PERSON.equals(name)) {
            this.plans.addPerson(this.currperson);
            this.currperson = null;
        } else if (PLAN.equals(name)) {
            if (this.currplan.getPlanElements() instanceof ArrayList) {
                ((ArrayList)this.currplan.getPlanElements()).trimToSize();
            }
            this.currplan = null;
        } else if (LEG.equals(name)) {
            this.currleg = null;
        } else if (ROUTE.equals(name)) {
            this.routeNodes = content;
        }
    }

    private void startPlans(Attributes atts) {
        this.plans.setName(atts.getValue("name"));
    }

    private void startPerson(Attributes atts) {
        this.currperson = PopulationUtils.getFactory().createPerson(Id.create(atts.getValue("id"), Person.class));
        PersonUtils.setSex(this.currperson, atts.getValue("sex"));
        PersonUtils.setAge(this.currperson, Integer.parseInt(atts.getValue("age")));
        PersonUtils.setLicence(this.currperson, atts.getValue("license"));
        PersonUtils.setCarAvail(this.currperson, atts.getValue("car_avail"));
        String employed = atts.getValue("employed");
        if (employed == null) {
            PersonUtils.setEmployed(this.currperson, null);
        } else {
            PersonUtils.setEmployed(this.currperson, "yes".equals(employed));
        }
    }

    private void startPlan(Attributes atts) {
        boolean selected;
        String sel = atts.getValue("selected");
        if (sel.equals("yes")) {
            selected = true;
        } else if (sel.equals("no")) {
            selected = false;
        } else {
            throw new NumberFormatException("Attribute 'selected' of Element 'Plan' is neither 'yes' nor 'no'.");
        }
        this.currplan = PersonUtils.createAndAddPlan(this.currperson, selected);
        this.routeNodes = null;
        String scoreString = atts.getValue("score");
        if (scoreString != null) {
            double score = Double.parseDouble(scoreString);
            this.currplan.setScore(score);
        }
    }

    private void startAct(Attributes atts) {
        Activity act = null;
        if (atts.getValue("link") != null) {
            Id<Link> linkId = Id.create(atts.getValue("link"), Link.class);
            act = PopulationUtils.createAndAddActivityFromLinkId(this.currplan, atts.getValue("type"), linkId);
            if (atts.getValue(ATTR_X100) != null && atts.getValue(ATTR_Y100) != null) {
                Coord coord = this.parseCoord(atts);
                act.setCoord(coord);
            }
        } else if (atts.getValue(ATTR_X100) != null && atts.getValue(ATTR_Y100) != null) {
            Coord coord = this.parseCoord(atts);
            act = PopulationUtils.createAndAddActivityFromCoord(this.currplan, atts.getValue("type"), coord);
        } else {
            throw new IllegalArgumentException("Either the coords or the link must be specified for an Act.");
        }
        act.setStartTime(Time.parseTime(atts.getValue("start_time")));
        act.setMaximumDuration(Time.parseTime(atts.getValue("dur")));
        act.setEndTime(Time.parseTime(atts.getValue("end_time")));
        if (this.routeNodes != null) {
            this.currroute.setLinkIds(this.prevAct.getLinkId(), NetworkUtils.getLinkIds(RouteUtils.getLinksFromNodes(NetworkUtils.getNodes(this.network, this.routeNodes))), act.getLinkId());
            this.routeNodes = null;
            this.currroute = null;
        }
        this.prevAct = act;
    }

    private Coord parseCoord(Attributes atts) {
        return this.coordinateTransformation.transform(new Coord(Double.parseDouble(atts.getValue(ATTR_X100)), Double.parseDouble(atts.getValue(ATTR_Y100))));
    }

    private void startLeg(Attributes atts) {
        this.currleg = PopulationUtils.createAndAddLeg(this.currplan, atts.getValue("mode").toLowerCase(Locale.ROOT).intern());
        this.currleg.setDepartureTime(Time.parseTime(atts.getValue("dep_time")));
        this.currleg.setTravelTime(Time.parseTime(atts.getValue("trav_time")));
    }

    private void startRoute(Attributes atts) {
        this.currroute = this.plans.getFactory().getRouteFactories().createRoute(NetworkRoute.class, this.prevAct.getLinkId(), this.prevAct.getLinkId());
        this.currleg.setRoute(this.currroute);
        if (atts.getValue("dist") != null) {
            this.currroute.setDistance(Double.parseDouble(atts.getValue("dist")));
        }
        if (atts.getValue("trav_time") != null) {
            this.currroute.setTravelTime(Time.parseTime(atts.getValue("trav_time")));
        }
    }
}

