/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.io;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.api.internal.MatsimReader;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.population.PersonUtils;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.core.utils.misc.Time;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.ActivityFacility;
import org.matsim.facilities.ActivityOption;
import org.matsim.pt.routes.ExperimentalTransitRoute;
import org.xml.sax.Attributes;

class PopulationReaderMatsimV4
extends MatsimXmlParser
implements MatsimReader {
    static final String PLANS = "plans";
    static final String PERSON = "person";
    private static final String TRAVELCARD = "travelcard";
    private static final String DESIRES = "desires";
    private static final String ACTDUR = "actDur";
    private static final String KNOWLEDGE = "knowledge";
    private static final String ACTIVITYSPACE = "activityspace";
    private static final String ACTIVITY = "activity";
    private static final String LOCATION = "location";
    private static final String CAPACITY = "capacity";
    private static final String OPENTIME = "opentime";
    private static final String PLAN = "plan";
    private static final String ACT = "act";
    private static final String LEG = "leg";
    private static final String ROUTE = "route";
    private static final String ATTR_TYPE = "type";
    private final CoordinateTransformation coordinateTransformation;
    final Scenario scenario;
    final Population plans;
    private final Network network;
    private final ActivityFacilities facilities;
    Person currperson = null;
    private String curracttype = null;
    private ActivityOption curractivity = null;
    private Plan currplan = null;
    private Activity curract = null;
    private Leg currleg = null;
    private Route currRoute = null;
    private String routeDescription = null;
    private Activity prevAct = null;
    private static final Logger log = Logger.getLogger(PopulationReaderMatsimV4.class);

    public PopulationReaderMatsimV4(Scenario scenario) {
        this(new IdentityTransformation(), scenario);
    }

    public PopulationReaderMatsimV4(CoordinateTransformation coordinateTransformation, Scenario scenario) {
        this.coordinateTransformation = coordinateTransformation;
        this.scenario = scenario;
        this.plans = scenario.getPopulation();
        this.network = scenario.getNetwork();
        this.facilities = scenario.getActivityFacilities();
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        if (PLANS.equals(name)) {
            this.startPlans(atts);
        } else if (PERSON.equals(name)) {
            this.startPerson(atts);
        } else if (TRAVELCARD.equals(name)) {
            this.startTravelcard(atts);
        } else if (DESIRES.equals(name)) {
            log.error("Desires are no longer supported and will be ignored.");
        } else if (ACTDUR.equals(name)) {
            log.error("Desires are no longer supported and will be ignored.");
        } else if (!KNOWLEDGE.equals(name)) {
            if (ACTIVITYSPACE.equals(name)) {
                log.warn("<activityspace> will be ignored.");
            } else if (ACTIVITY.equals(name)) {
                this.startActivityFacility(atts);
            } else if (LOCATION.equals(name)) {
                this.startLocation(atts);
            } else if (CAPACITY.equals(name)) {
                log.warn("<capacity> will be ignored!");
            } else if (OPENTIME.equals(name)) {
                log.warn("<opentime> will be ignored!");
            } else if (PLAN.equals(name)) {
                this.startPlan(atts);
            } else if (ACT.equals(name)) {
                this.startAct(atts);
            } else if (LEG.equals(name)) {
                this.startLeg(atts);
            } else if (ROUTE.equals(name)) {
                this.startRoute(atts);
            } else {
                throw new RuntimeException(this + "[tag=" + name + " not known or not supported]");
            }
        }
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if (PERSON.equals(name)) {
            this.plans.addPerson(this.currperson);
            this.currperson = null;
        } else if (ACTIVITY.equals(name)) {
            this.curracttype = null;
        } else if (LOCATION.equals(name)) {
            this.curractivity = null;
        } else if (PLAN.equals(name)) {
            if (this.currplan.getPlanElements() instanceof ArrayList) {
                ((ArrayList)this.currplan.getPlanElements()).trimToSize();
            }
            this.currplan = null;
        } else if (ACT.equals(name)) {
            this.prevAct = this.curract;
            this.curract = null;
        } else if (ROUTE.equals(name)) {
            this.routeDescription = content;
        }
    }

    void startPlans(Attributes atts) {
        this.plans.setName(atts.getValue("name"));
        if (atts.getValue("reference_layer") != null) {
            log.warn("plans.reference_layer is no longer supported.");
        }
    }

    private void startPerson(Attributes atts) {
        String ageString = atts.getValue("age");
        Integer age = null;
        if (ageString != null) {
            age = Integer.parseInt(ageString);
        }
        this.currperson = PopulationUtils.getFactory().createPerson(Id.create(atts.getValue("id"), Person.class));
        PersonUtils.setSex(this.currperson, atts.getValue("sex"));
        PersonUtils.setAge(this.currperson, age);
        PersonUtils.setLicence(this.currperson, atts.getValue("license"));
        PersonUtils.setCarAvail(this.currperson, atts.getValue("car_avail"));
        String employed = atts.getValue("employed");
        if (employed == null) {
            PersonUtils.setEmployed(this.currperson, null);
        } else {
            PersonUtils.setEmployed(this.currperson, "yes".equals(employed));
        }
    }

    private void startTravelcard(Attributes atts) {
        PersonUtils.addTravelcard(this.currperson, atts.getValue(ATTR_TYPE));
    }

    private void startActivityFacility(Attributes atts) {
        this.curracttype = atts.getValue(ATTR_TYPE);
    }

    private void startLocation(Attributes atts) {
        ActivityFacility currfacility;
        String type = atts.getValue(ATTR_TYPE);
        String id = atts.getValue("id");
        String x = atts.getValue("x");
        String y = atts.getValue("y");
        String freq = atts.getValue("freq");
        if (type != null) {
            log.info("Attribute type in <location> is deprecated!");
        }
        if (id == null) {
            throw new RuntimeException("NEW: location must have an id!");
        }
        if (x != null || y != null) {
            log.info("NEW: coords in <location> will be ignored!");
        }
        if (freq != null) {
            log.info("NEW: Attribute freq in <location> is not supported at the moment!");
        }
        if ((currfacility = this.facilities.getFacilities().get(Id.create(id, ActivityFacility.class))) == null) {
            throw new RuntimeException("facility id=" + id + " does not exist!");
        }
        this.curractivity = currfacility.getActivityOptions().get(this.curracttype);
        if (this.curractivity == null) {
            throw new RuntimeException("facility id=" + id + ": Activity of type=" + this.curracttype + " does not exist!");
        }
    }

    private void startPlan(Attributes atts) {
        boolean selected;
        String sel = atts.getValue("selected");
        if (sel.equals("yes")) {
            selected = true;
        } else if (sel.equals("no")) {
            selected = false;
        } else {
            throw new NumberFormatException("Attribute 'selected' of Element 'Plan' is neither 'yes' nor 'no'.");
        }
        this.routeDescription = null;
        this.currplan = PersonUtils.createAndAddPlan(this.currperson, selected);
        String scoreString = atts.getValue("score");
        if (scoreString != null) {
            double score = Double.parseDouble(scoreString);
            this.currplan.setScore(score);
        }
        String type = atts.getValue(ATTR_TYPE);
        this.currplan.setType(type);
    }

    private void startAct(Attributes atts) {
        if (atts.getValue("link") != null) {
            Id<Link> linkId;
            Id<Link> linkId1 = linkId = Id.create(atts.getValue("link"), Link.class);
            this.curract = PopulationUtils.createAndAddActivityFromLinkId(this.currplan, atts.getValue(ATTR_TYPE), linkId1);
            if (atts.getValue("x") != null && atts.getValue("y") != null) {
                Coord coord = this.parseCoord(atts);
                this.curract.setCoord(coord);
            }
        } else if (atts.getValue("x") != null && atts.getValue("y") != null) {
            Coord coord = this.parseCoord(atts);
            this.curract = PopulationUtils.createAndAddActivityFromCoord(this.currplan, atts.getValue(ATTR_TYPE), coord);
        } else {
            throw new IllegalArgumentException("In this version of MATSim either the coords or the link must be specified for an Act.");
        }
        this.curract.setStartTime(Time.parseTime(atts.getValue("start_time")));
        this.curract.setMaximumDuration(Time.parseTime(atts.getValue("dur")));
        this.curract.setEndTime(Time.parseTime(atts.getValue("end_time")));
        String fId = atts.getValue("facility");
        if (fId != null) {
            this.curract.setFacilityId(Id.create(fId, ActivityFacility.class));
        }
        if (this.routeDescription != null) {
            Id<Link> startLinkId = null;
            if (this.prevAct.getLinkId() != null) {
                startLinkId = this.prevAct.getLinkId();
            }
            Id<Link> endLinkId = null;
            if (this.curract.getLinkId() != null) {
                endLinkId = this.curract.getLinkId();
            }
            this.currRoute.setStartLinkId(startLinkId);
            this.currRoute.setEndLinkId(endLinkId);
            if (this.currRoute instanceof NetworkRoute) {
                ((NetworkRoute)this.currRoute).setLinkIds(startLinkId, NetworkUtils.getLinkIds(RouteUtils.getLinksFromNodes(NetworkUtils.getNodes(this.network, this.routeDescription))), endLinkId);
            } else {
                this.currRoute.setRouteDescription(this.routeDescription.trim());
            }
            this.routeDescription = null;
            this.currRoute = null;
        }
    }

    private Coord parseCoord(Attributes atts) {
        return this.coordinateTransformation.transform(new Coord(Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y"))));
    }

    private void startLeg(Attributes atts) {
        String mode = atts.getValue("mode").toLowerCase(Locale.ROOT);
        if (mode.equals("undef")) {
            mode = "undefined";
        }
        this.currleg = PopulationUtils.createAndAddLeg(this.currplan, mode.intern());
        this.currleg.setDepartureTime(Time.parseTime(atts.getValue("dep_time")));
        this.currleg.setTravelTime(Time.parseTime(atts.getValue("trav_time")));
    }

    private void startRoute(Attributes atts) {
        Class<Route> routeType = Route.class;
        if ("pt".equals(this.currleg.getMode())) {
            routeType = ExperimentalTransitRoute.class;
        }
        if ("car".equals(this.currleg.getMode())) {
            routeType = NetworkRoute.class;
        }
        this.currRoute = this.plans.getFactory().getRouteFactories().createRoute(routeType, null, null);
        this.currleg.setRoute(this.currRoute);
        if (atts.getValue("dist") != null) {
            this.currRoute.setDistance(Double.parseDouble(atts.getValue("dist")));
        }
        if (atts.getValue("trav_time") != null) {
            this.currRoute.setTravelTime(Time.parseTime(atts.getValue("trav_time")));
        }
    }
}

