/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.io;

import java.util.ArrayList;
import java.util.Stack;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.api.internal.MatsimReader;
import org.matsim.core.population.PersonUtils;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteFactories;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.core.utils.misc.Time;
import org.matsim.facilities.ActivityFacility;
import org.matsim.vehicles.Vehicle;
import org.xml.sax.Attributes;

class PopulationReaderMatsimV5
extends MatsimXmlParser
implements MatsimReader {
    private static final String POPULATION = "population";
    private static final String PERSON = "person";
    private static final String PLAN = "plan";
    private static final String ACT = "act";
    private static final String LEG = "leg";
    private static final String ROUTE = "route";
    private static final String ATTR_POPULATION_DESC = "desc";
    private static final String ATTR_PERSON_ID = "id";
    private static final String ATTR_PERSON_SEX = "sex";
    private static final String ATTR_PERSON_AGE = "age";
    private static final String ATTR_PERSON_LICENSE = "license";
    private static final String ATTR_PERSON_CARAVAIL = "car_avail";
    private static final String ATTR_PERSON_EMPLOYED = "employed";
    private static final String ATTR_PLAN_SCORE = "score";
    private static final String ATTR_PLAN_TYPE = "type";
    private static final String ATTR_PLAN_SELECTED = "selected";
    private static final String ATTR_ACT_TYPE = "type";
    private static final String ATTR_ACT_X = "x";
    private static final String ATTR_ACT_Y = "y";
    private static final String ATTR_ACT_LINK = "link";
    private static final String ATTR_ACT_FACILITY = "facility";
    private static final String ATTR_ACT_STARTTIME = "start_time";
    private static final String ATTR_ACT_ENDTIME = "end_time";
    private static final String ATTR_ACT_MAXDUR = "max_dur";
    private static final String ATTR_LEG_MODE = "mode";
    private static final String ATTR_LEG_DEPTIME = "dep_time";
    private static final String ATTR_LEG_TRAVTIME = "trav_time";
    private static final String ATTR_ROUTE_STARTLINK = "start_link";
    private static final String ATTR_ROUTE_ENDLINK = "end_link";
    private static final String VALUE_YES = "yes";
    private static final String VALUE_NO = "no";
    private static final String VALUE_UNDEF = "undef";
    private final CoordinateTransformation coordinateTransformation;
    private final Scenario scenario;
    private final Population plans;
    private Person currperson = null;
    private Plan currplan = null;
    private Activity curract = null;
    private Leg currleg = null;
    private Route currRoute = null;
    private String routeDescription = null;
    private Activity prevAct = null;

    PopulationReaderMatsimV5(Scenario scenario) {
        this(new IdentityTransformation(), scenario);
    }

    PopulationReaderMatsimV5(CoordinateTransformation coordinateTransformation, Scenario scenario) {
        this.coordinateTransformation = coordinateTransformation;
        this.scenario = scenario;
        this.plans = scenario.getPopulation();
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        if (POPULATION.equals(name)) {
            this.startPopulation(atts);
        } else if (PERSON.equals(name)) {
            this.startPerson(atts);
        } else if (PLAN.equals(name)) {
            this.startPlan(atts);
        } else if (ACT.equals(name)) {
            this.startAct(atts);
        } else if (LEG.equals(name)) {
            this.startLeg(atts);
        } else if (ROUTE.equals(name)) {
            this.startRoute(atts);
        } else {
            throw new RuntimeException(this + "[tag=" + name + " not known or not supported]");
        }
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if (PERSON.equals(name)) {
            this.plans.addPerson(this.currperson);
            this.currperson = null;
        } else if (PLAN.equals(name)) {
            if (this.currplan.getPlanElements() instanceof ArrayList) {
                ((ArrayList)this.currplan.getPlanElements()).trimToSize();
            }
            this.currplan = null;
        } else if (ACT.equals(name)) {
            this.prevAct = this.curract;
            this.curract = null;
        } else if (ROUTE.equals(name)) {
            this.endRoute(content);
        }
    }

    private void startPopulation(Attributes atts) {
        this.plans.setName(atts.getValue(ATTR_POPULATION_DESC));
    }

    private void startPerson(Attributes atts) {
        String ageString = atts.getValue(ATTR_PERSON_AGE);
        Integer age = null;
        if (ageString != null) {
            age = Integer.parseInt(ageString);
        }
        this.currperson = PopulationUtils.getFactory().createPerson(Id.create(atts.getValue(ATTR_PERSON_ID), Person.class));
        PersonUtils.setSex(this.currperson, atts.getValue(ATTR_PERSON_SEX));
        PersonUtils.setAge(this.currperson, age);
        PersonUtils.setLicence(this.currperson, atts.getValue(ATTR_PERSON_LICENSE));
        PersonUtils.setCarAvail(this.currperson, atts.getValue(ATTR_PERSON_CARAVAIL));
        String employed = atts.getValue(ATTR_PERSON_EMPLOYED);
        if (employed == null) {
            PersonUtils.setEmployed(this.currperson, null);
        } else {
            PersonUtils.setEmployed(this.currperson, VALUE_YES.equals(employed));
        }
    }

    private void startPlan(Attributes atts) {
        String type;
        boolean selected;
        String sel = atts.getValue(ATTR_PLAN_SELECTED);
        if (VALUE_YES.equals(sel)) {
            selected = true;
        } else if (VALUE_NO.equals(sel)) {
            selected = false;
        } else {
            throw new IllegalArgumentException("Attribute 'selected' of Element 'Plan' is neither 'yes' nor 'no'.");
        }
        this.routeDescription = null;
        this.currplan = PersonUtils.createAndAddPlan(this.currperson, selected);
        String scoreString = atts.getValue(ATTR_PLAN_SCORE);
        if (scoreString != null) {
            double score = Double.parseDouble(scoreString);
            this.currplan.setScore(score);
        }
        if ((type = atts.getValue("type")) != null) {
            this.currplan.setType(type);
        }
    }

    private void startAct(Attributes atts) {
        if (atts.getValue(ATTR_ACT_LINK) != null) {
            Id<Link> linkId1 = Id.create(atts.getValue(ATTR_ACT_LINK), Link.class);
            this.curract = PopulationUtils.createAndAddActivityFromLinkId(this.currplan, atts.getValue("type"), linkId1);
            if (atts.getValue(ATTR_ACT_X) != null && atts.getValue(ATTR_ACT_Y) != null) {
                Coord coord = this.parseCoord(atts);
                this.curract.setCoord(coord);
            }
        } else if (atts.getValue(ATTR_ACT_X) != null && atts.getValue(ATTR_ACT_Y) != null) {
            Coord coord = this.parseCoord(atts);
            this.curract = PopulationUtils.createAndAddActivityFromCoord(this.currplan, atts.getValue("type"), coord);
        } else {
            throw new IllegalArgumentException("In this version of MATSim either the coords or the link must be specified for an Act.");
        }
        this.curract.setStartTime(Time.parseTime(atts.getValue(ATTR_ACT_STARTTIME)));
        this.curract.setMaximumDuration(Time.parseTime(atts.getValue(ATTR_ACT_MAXDUR)));
        this.curract.setEndTime(Time.parseTime(atts.getValue(ATTR_ACT_ENDTIME)));
        String fId = atts.getValue(ATTR_ACT_FACILITY);
        if (fId != null) {
            this.curract.setFacilityId(Id.create(fId, ActivityFacility.class));
        }
        if (this.routeDescription != null) {
            this.finishLastRoute();
        }
    }

    private Coord parseCoord(Attributes atts) {
        return this.coordinateTransformation.transform(new Coord(Double.parseDouble(atts.getValue(ATTR_ACT_X)), Double.parseDouble(atts.getValue(ATTR_ACT_Y))));
    }

    private void finishLastRoute() {
        Id<Link> startLinkId = null;
        if (this.currRoute.getStartLinkId() != null) {
            startLinkId = this.currRoute.getStartLinkId();
        } else if (this.prevAct.getLinkId() != null) {
            startLinkId = this.prevAct.getLinkId();
        }
        Id<Link> endLinkId = null;
        if (this.currRoute.getEndLinkId() != null) {
            endLinkId = this.currRoute.getEndLinkId();
        } else if (this.curract != null && this.curract.getLinkId() != null) {
            endLinkId = this.curract.getLinkId();
        }
        this.currRoute.setStartLinkId(startLinkId);
        this.currRoute.setEndLinkId(endLinkId);
        this.currRoute.setRouteDescription(this.routeDescription.trim());
        if (Double.isNaN(this.currRoute.getDistance())) {
            if (this.currRoute instanceof NetworkRoute) {
                if (!this.scenario.getNetwork().getLinks().isEmpty()) {
                    this.currRoute.setDistance(RouteUtils.calcDistanceExcludingStartEndLink((NetworkRoute)this.currRoute, this.scenario.getNetwork()));
                }
            } else {
                Coord fromCoord = this.getCoord(this.prevAct);
                Coord toCoord = this.getCoord(this.curract);
                if (fromCoord != null && toCoord != null) {
                    double dist = CoordUtils.calcEuclideanDistance(fromCoord, toCoord);
                    if (this.scenario.getConfig().plansCalcRoute().getModeRoutingParams().containsKey(this.currleg.getMode())) {
                        double estimatedNetworkDistance = dist * this.scenario.getConfig().plansCalcRoute().getModeRoutingParams().get(this.currleg.getMode()).getBeelineDistanceFactor();
                        this.currRoute.setDistance(estimatedNetworkDistance);
                    }
                }
            }
        }
        if (Time.isUndefinedTime(this.currRoute.getTravelTime())) {
            this.currRoute.setTravelTime(this.currleg.getTravelTime());
        }
        this.routeDescription = null;
        this.currRoute = null;
    }

    private Coord getCoord(Activity activity) {
        if (activity == null) {
            return null;
        }
        Coord fromCoord = activity.getCoord() != null ? activity.getCoord() : (!this.scenario.getNetwork().getLinks().isEmpty() ? this.scenario.getNetwork().getLinks().get(activity.getLinkId()).getCoord() : null);
        return fromCoord;
    }

    private void startLeg(Attributes atts) {
        String mode;
        if (this.routeDescription != null) {
            this.finishLastRoute();
        }
        if (VALUE_UNDEF.equals(mode = atts.getValue(ATTR_LEG_MODE))) {
            mode = "undefined";
        }
        this.currleg = PopulationUtils.createAndAddLeg(this.currplan, mode.intern());
        this.currleg.setDepartureTime(Time.parseTime(atts.getValue(ATTR_LEG_DEPTIME)));
        this.currleg.setTravelTime(Time.parseTime(atts.getValue(ATTR_LEG_TRAVTIME)));
    }

    private void startRoute(Attributes atts) {
        String startLinkId = atts.getValue(ATTR_ROUTE_STARTLINK);
        String endLinkId = atts.getValue(ATTR_ROUTE_ENDLINK);
        String routeType = atts.getValue("type");
        if (routeType == null) {
            String legMode = this.currleg.getMode();
            routeType = "pt".equals(legMode) ? "experimentalPt1" : ("car".equals(legMode) ? "links" : "generic");
        }
        RouteFactories factory = this.scenario.getPopulation().getFactory().getRouteFactories();
        Class<? extends Route> routeClass = factory.getRouteClassForType(routeType);
        this.currRoute = this.scenario.getPopulation().getFactory().getRouteFactories().createRoute(routeClass, startLinkId == null ? null : Id.create(startLinkId, Link.class), endLinkId == null ? null : Id.create(endLinkId, Link.class));
        this.currleg.setRoute(this.currRoute);
        if (atts.getValue(ATTR_LEG_TRAVTIME) != null) {
            this.currRoute.setTravelTime(Time.parseTime(atts.getValue(ATTR_LEG_TRAVTIME)));
        }
        if (atts.getValue("distance") != null) {
            this.currRoute.setDistance(Double.parseDouble(atts.getValue("distance")));
        }
        if (atts.getValue("vehicleRefId") != null && this.currRoute instanceof NetworkRoute) {
            ((NetworkRoute)this.currRoute).setVehicleId(Id.create(atts.getValue("vehicleRefId"), Vehicle.class));
        }
    }

    private void endRoute(String content) {
        this.routeDescription = content;
        Id<Link> startLinkId = this.currRoute.getStartLinkId();
        Id<Link> endLinkId = this.currRoute.getEndLinkId();
        this.currRoute.setStartLinkId(startLinkId);
        this.currRoute.setEndLinkId(endLinkId);
        this.currRoute.setRouteDescription(this.routeDescription.trim());
        if (Double.isNaN(this.currRoute.getDistance())) {
            if (this.currRoute instanceof NetworkRoute) {
                if (!this.scenario.getNetwork().getLinks().isEmpty()) {
                    this.currRoute.setDistance(RouteUtils.calcDistanceExcludingStartEndLink((NetworkRoute)this.currRoute, this.scenario.getNetwork()));
                }
            } else {
                Coord fromCoord = this.getCoord(this.prevAct);
                Coord toCoord = this.getCoord(this.curract);
                if (fromCoord != null && toCoord != null) {
                    double dist = CoordUtils.calcEuclideanDistance(fromCoord, toCoord);
                    if (this.scenario.getConfig().plansCalcRoute().getModeRoutingParams().containsKey(this.currleg.getMode())) {
                        double estimatedNetworkDistance = dist * this.scenario.getConfig().plansCalcRoute().getModeRoutingParams().get(this.currleg.getMode()).getBeelineDistanceFactor();
                        this.currRoute.setDistance(estimatedNetworkDistance);
                    }
                }
            }
        }
        if (Time.isUndefinedTime(this.currRoute.getTravelTime())) {
            this.currRoute.setTravelTime(this.currleg.getTravelTime());
        }
        if (this.currRoute.getEndLinkId() != null) {
            this.currRoute = null;
            this.routeDescription = null;
        }
    }
}

