/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.api.internal.MatsimWriter;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.io.PopulationWriterHandler;
import org.matsim.core.population.io.PopulationWriterHandlerImplV0;
import org.matsim.core.population.io.PopulationWriterHandlerImplV4;
import org.matsim.core.population.io.PopulationWriterHandlerImplV5;
import org.matsim.core.population.io.PopulationWriterHandlerImplV6;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.io.AbstractMatsimWriter;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.core.utils.misc.Counter;
import org.matsim.utils.objectattributes.AttributeConverter;

public final class PopulationWriter
extends AbstractMatsimWriter
implements MatsimWriter {
    private final double write_person_fraction;
    private final CoordinateTransformation coordinateTransformation;
    private PopulationWriterHandler handler = null;
    private final Population population;
    private final Network network;
    private Counter counter = new Counter("[" + this.getClass().getSimpleName() + "] dumped person # ");
    private static final Logger log = Logger.getLogger(PopulationWriter.class);
    private Map<Class<?>, AttributeConverter<?>> converters = new HashMap();

    public PopulationWriter(Population population) {
        this(population, null, 1.0);
    }

    public PopulationWriter(CoordinateTransformation coordinateTransformation, Population population) {
        this(coordinateTransformation, population, null, 1.0);
    }

    public PopulationWriter(Population population, Network network) {
        this(population, network, 1.0);
    }

    public PopulationWriter(CoordinateTransformation coordinateTransformation, Population population, Network network) {
        this(coordinateTransformation, population, network, 1.0);
    }

    public PopulationWriter(CoordinateTransformation coordinateTransformation, Population population, Network network, double fraction) {
        this.coordinateTransformation = coordinateTransformation;
        this.population = population;
        this.network = network;
        this.write_person_fraction = fraction;
        this.handler = new PopulationWriterHandlerImplV6(coordinateTransformation);
    }

    public PopulationWriter(Population population, Network network, double fraction) {
        this(new IdentityTransformation(), population, network, fraction);
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.converters.putAll(converters);
    }

    public void putAttributeConverter(Class<?> key, AttributeConverter<?> converter) {
        this.converters.put(key, converter);
    }

    @Override
    public final void write(String filename) {
        try {
            this.handler.putAttributeConverters(this.converters);
            this.openFile(filename);
            this.handler.writeHeaderAndStartElement(this.writer);
            this.handler.startPlans(this.population, this.writer);
            this.handler.writeSeparator(this.writer);
            this.writePersons();
            this.handler.endPlans(this.writer);
            log.info("Population written to: " + filename);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.close();
            this.counter.printCounter();
            this.counter.reset();
        }
    }

    public final void write(OutputStream outputStream) {
        try {
            this.handler.putAttributeConverters(this.converters);
            this.openOutputStream(outputStream);
            this.handler.writeHeaderAndStartElement(this.writer);
            this.handler.startPlans(this.population, this.writer);
            this.handler.writeSeparator(this.writer);
            this.writePersons();
            this.handler.endPlans(this.writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.close();
            this.counter.printCounter();
            this.counter.reset();
        }
    }

    private final void writePersons() {
        for (Person p : PopulationUtils.getSortedPersons(this.population).values()) {
            this.writePerson(p);
        }
    }

    private final void writePerson(Person person) {
        try {
            if (this.write_person_fraction < 1.0 && MatsimRandom.getRandom().nextDouble() >= this.write_person_fraction) {
                return;
            }
            this.handler.writePerson(person, this.writer);
            this.counter.incCounter();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public final void writeV0(String filename) {
        this.handler = new PopulationWriterHandlerImplV0(this.coordinateTransformation, this.network);
        this.write(filename);
    }

    public final void writeV4(String filename) {
        this.handler = new PopulationWriterHandlerImplV4(this.coordinateTransformation, this.network);
        this.write(filename);
    }

    public final void writeV5(String filename) {
        this.handler = new PopulationWriterHandlerImplV5(this.coordinateTransformation);
        this.write(filename);
    }

    public final void writeV6(String filename) {
        this.handler = new PopulationWriterHandlerImplV6(this.coordinateTransformation);
        this.write(filename);
    }

    public final void writeV6(OutputStream stream) {
        this.handler = new PopulationWriterHandlerImplV6(this.coordinateTransformation);
        this.write(stream);
    }

    public final void setWriterHandler(PopulationWriterHandler handler) {
        this.handler = handler;
    }
}

