/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.io;

import java.io.BufferedWriter;
import java.io.IOException;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.population.PersonUtils;
import org.matsim.core.population.io.AbstractPopulationWriterHandler;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.misc.Time;

class PopulationWriterHandlerImplV0
extends AbstractPopulationWriterHandler {
    private final CoordinateTransformation coordinateTransformation;
    private final Network network;

    protected PopulationWriterHandlerImplV0(CoordinateTransformation coordinateTransformation, Network network) {
        this.coordinateTransformation = coordinateTransformation;
        this.network = network;
    }

    @Override
    public void writeHeaderAndStartElement(BufferedWriter out) throws IOException {
        out.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        out.write("<!DOCTYPE plans SYSTEM \"http://www.matsim.org/files/dtd/plans_v0.dtd\">\n\n");
    }

    @Override
    public void startPlans(Population plans, BufferedWriter out) throws IOException {
        out.write("<plans>\n\n");
    }

    @Override
    public void endPlans(BufferedWriter out) throws IOException {
        out.write("</plans>\n");
    }

    @Override
    public void startPerson(Person person, BufferedWriter out) throws IOException {
        out.write("\t<person");
        out.write(" id=\"" + person.getId() + "\"");
        out.write(">\n");
    }

    @Override
    public void endPerson(BufferedWriter out) throws IOException {
        out.write("\t</person>\n\n");
    }

    @Override
    public void startTravelCard(String travelcard, BufferedWriter out) throws IOException {
    }

    @Override
    public void endTravelCard(BufferedWriter out) throws IOException {
    }

    @Override
    public void startPlan(Plan plan, BufferedWriter out) throws IOException {
        out.write("\t\t<plan");
        if (plan.getScore() != null) {
            out.write(" score=\"" + plan.getScore().toString() + "\"");
        }
        if (PersonUtils.isSelected(plan)) {
            out.write(" selected=\"yes\"");
        } else {
            out.write(" selected=\"no\"");
        }
        out.write(">\n");
    }

    @Override
    public void endPlan(BufferedWriter out) throws IOException {
        out.write("\t\t</plan>\n\n");
    }

    @Override
    public void startAct(Activity act, BufferedWriter out) throws IOException {
        out.write("\t\t\t<act");
        out.write(" type=\"" + act.getType() + "\"");
        if (act.getCoord() != null) {
            Coord coord = this.coordinateTransformation.transform(act.getCoord());
            out.write(" x100=\"" + coord.getX() + "\"");
            out.write(" y100=\"" + coord.getY() + "\"");
        }
        if (act.getLinkId() != null) {
            out.write(" link=\"" + act.getLinkId() + "\"");
        }
        if (act.getStartTime() != -2.147483648E9) {
            out.write(" start_time=\"" + Time.writeTime(act.getStartTime()) + "\"");
        }
        if (!Time.isUndefinedTime(act.getMaximumDuration())) {
            out.write(" dur=\"" + Time.writeTime(act.getMaximumDuration()) + "\"");
        }
        if (act.getEndTime() != -2.147483648E9) {
            out.write(" end_time=\"" + Time.writeTime(act.getEndTime()) + "\"");
        }
        out.write(" />\n");
    }

    @Override
    public void endAct(BufferedWriter out) throws IOException {
    }

    @Override
    public void startLeg(Leg leg, BufferedWriter out) throws IOException {
        out.write("\t\t\t<leg");
        out.write(" mode=\"" + leg.getMode() + "\"");
        if (leg.getDepartureTime() != -2.147483648E9) {
            out.write(" dep_time=\"" + Time.writeTime(leg.getDepartureTime()) + "\"");
        }
        if (leg.getTravelTime() != -2.147483648E9) {
            out.write(" trav_time=\"" + Time.writeTime(leg.getTravelTime()) + "\"");
        }
        out.write(">\n");
    }

    @Override
    public void endLeg(BufferedWriter out) throws IOException {
        out.write("\t\t\t</leg>\n");
    }

    @Override
    public void startRoute(Route route, BufferedWriter out) throws IOException {
        out.write("\t\t\t\t<route>");
        if (route instanceof NetworkRoute) {
            for (Node n : RouteUtils.getNodes((NetworkRoute)route, this.network)) {
                out.write(n.getId() + " ");
            }
        } else {
            out.write(route.getRouteDescription());
        }
    }

    @Override
    public void endRoute(BufferedWriter out) throws IOException {
        out.write("</route>\n");
    }

    @Override
    public void writeSeparator(BufferedWriter out) throws IOException {
        out.write("<!-- ====================================================================== -->\n\n");
    }
}

