/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.io;

import java.io.BufferedWriter;
import java.io.IOException;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.population.PersonUtils;
import org.matsim.core.population.io.AbstractPopulationWriterHandler;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.misc.Time;

class PopulationWriterHandlerImplV4
extends AbstractPopulationWriterHandler {
    private final CoordinateTransformation coordinateTransformation;
    private final Network network;

    public PopulationWriterHandlerImplV4(Network network) {
        this(new IdentityTransformation(), network);
    }

    public PopulationWriterHandlerImplV4(CoordinateTransformation coordinateTransformation, Network network) {
        this.coordinateTransformation = coordinateTransformation;
        this.network = network;
    }

    @Override
    public void writeHeaderAndStartElement(BufferedWriter out) throws IOException {
        out.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        out.write("<!DOCTYPE plans SYSTEM \"http://www.matsim.org/files/dtd/plans_v4.dtd\">\n\n");
    }

    @Override
    public void startPlans(Population plans, BufferedWriter out) throws IOException {
        out.write("<plans");
        if (plans.getName() != null) {
            out.write(" name=\"" + plans.getName() + "\"");
        }
        out.write(">\n\n");
    }

    @Override
    public void endPlans(BufferedWriter out) throws IOException {
        out.write("</plans>\n");
    }

    @Override
    public void startPerson(Person person, BufferedWriter out) throws IOException {
        out.write("\t<person id=\"");
        out.write(person.getId().toString());
        out.write("\"");
        if (PersonUtils.getSex(person) != null) {
            out.write(" sex=\"");
            out.write(PersonUtils.getSex(person));
            out.write("\"");
        }
        if (PersonUtils.getAge(person) != null) {
            out.write(" age=\"");
            out.write(Integer.toString(PersonUtils.getAge(person)));
            out.write("\"");
        }
        if (PersonUtils.getLicense(person) != null) {
            out.write(" license=\"");
            out.write(PersonUtils.getLicense(person));
            out.write("\"");
        }
        if (PersonUtils.getCarAvail(person) != null) {
            out.write(" car_avail=\"");
            out.write(PersonUtils.getCarAvail(person));
            out.write("\"");
        }
        if (PersonUtils.isEmployed(person) != null) {
            out.write(" employed=\"");
            out.write(PersonUtils.isEmployed(person) != false ? "yes" : "no");
            out.write("\"");
        }
        out.write(">\n");
    }

    @Override
    public void endPerson(BufferedWriter out) throws IOException {
        out.write("\t</person>\n\n");
    }

    @Override
    public void startTravelCard(String travelcard, BufferedWriter out) throws IOException {
        out.write("\t\t<travelcard type=\"");
        out.write(travelcard);
        out.write("\" />\n\n");
    }

    @Override
    public void endTravelCard(BufferedWriter out) throws IOException {
    }

    @Override
    public void startPlan(Plan plan, BufferedWriter out) throws IOException {
        out.write("\t\t<plan");
        if (plan.getScore() != null) {
            out.write(" score=\"");
            out.write(plan.getScore().toString());
            out.write("\"");
        }
        if (PersonUtils.isSelected(plan)) {
            out.write(" selected=\"yes\"");
        } else {
            out.write(" selected=\"no\"");
        }
        if (plan.getType() != null) {
            out.write(" type=\"");
            out.write(plan.getType());
            out.write("\"");
        }
        out.write(">\n");
    }

    @Override
    public void endPlan(BufferedWriter out) throws IOException {
        out.write("\t\t</plan>\n\n");
    }

    @Override
    public void startAct(Activity act, BufferedWriter out) throws IOException {
        out.write("\t\t\t<act type=\"");
        out.write(act.getType());
        out.write("\"");
        if (act.getLinkId() != null) {
            out.write(" link=\"");
            out.write(act.getLinkId().toString());
            out.write("\"");
        }
        if (act.getFacilityId() != null) {
            out.write(" facility=\"");
            out.write(act.getFacilityId().toString());
            out.write("\"");
        }
        if (act.getCoord() != null) {
            Coord coord = this.coordinateTransformation.transform(act.getCoord());
            out.write(" x=\"");
            out.write(Double.toString(coord.getX()));
            out.write("\" y=\"");
            out.write(Double.toString(coord.getY()));
            out.write("\"");
        }
        if (!Time.isUndefinedTime(act.getStartTime())) {
            out.write(" start_time=\"");
            out.write(Time.writeTime(act.getStartTime()));
            out.write("\"");
        }
        if (!Time.isUndefinedTime(act.getMaximumDuration())) {
            out.write(" dur=\"");
            out.write(Time.writeTime(act.getMaximumDuration()));
            out.write("\"");
        }
        if (!Time.isUndefinedTime(act.getEndTime())) {
            out.write(" end_time=\"");
            out.write(Time.writeTime(act.getEndTime()));
            out.write("\"");
        }
        out.write(" />\n");
    }

    @Override
    public void endAct(BufferedWriter out) throws IOException {
    }

    @Override
    public void startLeg(Leg leg, BufferedWriter out) throws IOException {
        out.write("\t\t\t<leg mode=\"");
        out.write(leg.getMode());
        out.write("\"");
        if (!Time.isUndefinedTime(leg.getDepartureTime())) {
            out.write(" dep_time=\"");
            out.write(Time.writeTime(leg.getDepartureTime()));
            out.write("\"");
        }
        if (!Time.isUndefinedTime(leg.getTravelTime())) {
            out.write(" trav_time=\"");
            out.write(Time.writeTime(leg.getTravelTime()));
            out.write("\"");
        }
        out.write(">\n");
    }

    @Override
    public void endLeg(BufferedWriter out) throws IOException {
        out.write("\t\t\t</leg>\n");
    }

    @Override
    public void startRoute(Route route, BufferedWriter out) throws IOException {
        out.write("\t\t\t\t<route");
        if (!Double.isNaN(route.getDistance())) {
            out.write(" dist=\"");
            out.write(Double.toString(route.getDistance()));
            out.write("\"");
        }
        if (!Time.isUndefinedTime(route.getTravelTime())) {
            out.write(" trav_time=\"");
            out.write(Time.writeTime(route.getTravelTime()));
            out.write("\"");
        }
        out.write(">\n");
        out.write("\t\t\t\t\t");
        if (route instanceof NetworkRoute) {
            for (Node n : RouteUtils.getNodes((NetworkRoute)route, this.network)) {
                out.write(n.getId().toString());
                out.write(" ");
            }
        } else {
            String rd = route.getRouteDescription();
            if (rd != null) {
                out.write(rd);
                out.write(" ");
            }
        }
        out.write("\n");
    }

    @Override
    public void endRoute(BufferedWriter out) throws IOException {
        out.write("\t\t\t\t</route>\n");
    }

    @Override
    public void writeSeparator(BufferedWriter out) throws IOException {
        out.write("<!-- ====================================================================== -->\n\n");
    }
}

