/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.io;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.api.internal.MatsimReader;
import org.matsim.core.config.Config;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.algorithms.PersonAlgorithm;
import org.matsim.core.population.io.PopulationReader;
import org.matsim.core.scenario.MutableScenario;
import org.matsim.utils.objectattributes.attributable.Attributes;

public final class StreamingPopulationReader
implements MatsimReader {
    private static final Logger log = Logger.getLogger(StreamingPopulationReader.class);
    private PopulationReader reader;
    private final StreamingPopulation pop;
    private int cnt;
    private final ArrayList<PersonAlgorithm> personAlgos = new ArrayList();

    public StreamingPopulationReader(Scenario scenario) {
        this(null, null, scenario);
    }

    public StreamingPopulationReader(String inputCRS, String targetCRS, Scenario scenario) {
        if (!(scenario instanceof MutableScenario)) {
            throw new RuntimeException("scenario given into this class needs to be an instance of MutableScenario.");
        }
        this.pop = new StreamingPopulation(scenario.getConfig());
        ((MutableScenario)scenario).setPopulation(this.pop);
        this.reader = new PopulationReader(inputCRS, targetCRS, scenario, true);
    }

    Population getStreamingPopulation() {
        return this.pop;
    }

    @Override
    public void readFile(String filename) {
        this.reader.readFile(filename);
    }

    @Override
    public void readURL(URL url) {
        this.reader.parse(url);
    }

    public void parse(InputStream is) {
        this.reader.parse(is);
    }

    public void parse(URL url) {
        this.reader.parse(url);
    }

    public final void clearAlgorithms() {
        this.personAlgos.clear();
    }

    public final void addAlgorithm(PersonAlgorithm algo) {
        this.personAlgos.add(algo);
    }

    @Deprecated
    public final boolean isStreaming() {
        return true;
    }

    @Deprecated
    final void setIsStreaming(boolean isStreaming) {
        if (!isStreaming) {
            log.error("streaming == false currently not supported with this approach; please program it yourself; something like");
            log.error("for ( Person person : pop.getPersons().values() ) {");
            log.error("   personAlgo.run( person ); ");
            log.error("}");
            throw new RuntimeException("streaming == false currently not supported with this approach; see log statements");
        }
    }

    public final String toString() {
        return "[nof_plansalgos=" + this.personAlgos.size() + "]";
    }

    @Deprecated
    public void printPlansCount() {
        log.info("processed " + this.cnt + " persons.");
    }

    final class StreamingPopulation
    implements Population {
        private Population delegate;

        StreamingPopulation(Config config) {
            this.delegate = PopulationUtils.createPopulation(config);
        }

        @Override
        public final void addPerson(Person p) {
            StreamingPopulationReader.this.cnt++;
            this.delegate.addPerson(p);
            for (PersonAlgorithm algo : StreamingPopulationReader.this.personAlgos) {
                algo.run(p);
            }
            this.delegate.removePerson(p.getId());
        }

        @Override
        public PopulationFactory getFactory() {
            return this.delegate.getFactory();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public void setName(String name) {
            this.delegate.setName(name);
        }

        @Override
        public Map<Id<Person>, ? extends Person> getPersons() {
            return this.delegate.getPersons();
        }

        @Override
        public Person removePerson(Id<Person> personId) {
            return this.delegate.removePerson(personId);
        }

        @Override
        public Attributes getAttributes() {
            return this.delegate.getAttributes();
        }
    }
}

