/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.population.algorithms.PersonAlgorithm;
import org.matsim.core.population.io.PopulationWriterHandler;
import org.matsim.core.population.io.PopulationWriterHandlerImplV6;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.core.utils.io.AbstractMatsimWriter;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.core.utils.misc.Counter;
import org.matsim.utils.objectattributes.attributable.Attributes;

public final class StreamingPopulationWriter
implements PersonAlgorithm {
    private static final Logger log = Logger.getLogger(StreamingPopulationWriter.class);
    private final double write_person_fraction;
    private PopulationWriterHandler handler = null;
    private Counter counter = new Counter("[" + this.getClass().getSimpleName() + "] dumped person # ");
    private DummyMatsimWriter matsimWriter = new DummyMatsimWriter();

    public StreamingPopulationWriter() {
        this(1.0);
    }

    public StreamingPopulationWriter(CoordinateTransformation coordinateTransformation) {
        this(coordinateTransformation, 1.0);
    }

    public StreamingPopulationWriter(CoordinateTransformation coordinateTransformation, double fraction) {
        this.write_person_fraction = fraction;
        this.handler = new PopulationWriterHandlerImplV6(coordinateTransformation);
    }

    public StreamingPopulationWriter(double fraction) {
        this(new IdentityTransformation(), fraction);
    }

    public final void startStreaming(String filename) {
        this.writeStartPlans(filename);
    }

    @Override
    public final void run(Person person) {
        this.writePerson(person);
    }

    public final void closeStreaming() {
        if (this.matsimWriter.getWriter() != null) {
            this.writeEndPlans();
        } else {
            log.error("Cannot close streaming. File is not open.");
        }
    }

    public final void writeStartPlans(String filename) {
        Population fakepop = new Population(){

            @Override
            public PopulationFactory getFactory() {
                throw new RuntimeException("not implemented");
            }

            @Override
            public String getName() {
                return "population written from streaming";
            }

            @Override
            public void setName(String name) {
                throw new RuntimeException("not implemented");
            }

            @Override
            public Map<Id<Person>, ? extends Person> getPersons() {
                throw new RuntimeException("not implemented");
            }

            @Override
            public void addPerson(Person p) {
                throw new RuntimeException("not implemented");
            }

            @Override
            public Person removePerson(Id<Person> personId) {
                throw new RuntimeException("not implemented");
            }

            @Override
            public Attributes getAttributes() {
                return new Attributes();
            }
        };
        try {
            this.matsimWriter.openHere(filename);
            this.handler.writeHeaderAndStartElement(this.matsimWriter.getWriter());
            this.handler.startPlans(fakepop, this.matsimWriter.getWriter());
            this.handler.writeSeparator(this.matsimWriter.getWriter());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Deprecated
    public final void writePersons() {
        throw new RuntimeException("this execution path does not longer exist.  See comments in code");
    }

    public final void writePerson(Person person) {
        try {
            if (this.write_person_fraction < 1.0 && MatsimRandom.getRandom().nextDouble() >= this.write_person_fraction) {
                return;
            }
            this.handler.writePerson(person, this.matsimWriter.getWriter());
            this.counter.incCounter();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public final void writeEndPlans() {
        try {
            this.handler.endPlans(this.matsimWriter.getWriter());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.matsimWriter.closeHere();
    }

    public final void setWriterHandler(PopulationWriterHandler handler) {
        this.handler = handler;
    }

    private static class DummyMatsimWriter
    extends AbstractMatsimWriter {
        private DummyMatsimWriter() {
        }

        BufferedWriter getWriter() {
            return this.writer;
        }

        void openHere(String filename) {
            super.openFile(filename);
        }

        void closeHere() {
            super.close();
        }
    }
}

