/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.routes;

import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.utils.misc.Time;

public abstract class AbstractRoute
implements Route,
Cloneable {
    private boolean locked = false;
    private double dist = Double.NaN;
    private double travTime = Time.getUndefinedTime();
    private Id<Link> startLinkId = null;
    private Id<Link> endLinkId = null;

    public AbstractRoute(Id<Link> startLinkId, Id<Link> endLinkId) {
        this.startLinkId = startLinkId;
        this.endLinkId = endLinkId;
    }

    @Override
    public final double getDistance() {
        return this.dist;
    }

    @Override
    public final void setDistance(double dist) {
        this.dist = dist;
    }

    @Override
    public final double getTravelTime() {
        return this.travTime;
    }

    @Override
    public final void setTravelTime(double travTime) {
        this.travTime = travTime;
    }

    @Override
    public final void setEndLinkId(Id<Link> linkId) {
        this.testForLocked();
        this.endLinkId = linkId;
    }

    @Override
    public final void setStartLinkId(Id<Link> linkId) {
        this.testForLocked();
        this.startLinkId = linkId;
    }

    @Override
    public final Id<Link> getStartLinkId() {
        return this.startLinkId;
    }

    @Override
    public final Id<Link> getEndLinkId() {
        return this.endLinkId;
    }

    public final void setLocked() {
        this.locked = true;
    }

    @Override
    public AbstractRoute clone() {
        try {
            AbstractRoute clone = (AbstractRoute)super.clone();
            clone.locked = false;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        String str = "";
        str = str + " startLinkId=" + this.startLinkId;
        str = str + " endLinkId=" + this.endLinkId;
        str = str + " travTime=" + this.travTime;
        str = str + " dist=" + this.dist;
        return str;
    }

    private void testForLocked() {
        if (this.locked) {
            throw new RuntimeException("Route is locked; too late to do this.  See comments in code.");
        }
    }
}

