/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.routes;

import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.network.algorithms.SubsequentLinksAnalyzer;
import org.matsim.core.population.routes.CompressedNetworkRouteImpl;
import org.matsim.core.population.routes.RouteFactory;

public final class CompressedNetworkRouteFactory
implements RouteFactory {
    private Map<Id<Link>, Id<Link>> subsequentLinks = null;
    private final Network network;

    public CompressedNetworkRouteFactory(Network network) {
        this.network = network;
    }

    @Override
    public Route createRoute(Id<Link> startLinkId, Id<Link> endLinkId) {
        if (this.network == null) {
            throw new RuntimeException("need to set Network in Population in order to be able to create compressed routes");
        }
        if (this.subsequentLinks == null) {
            this.subsequentLinks = new SubsequentLinksAnalyzer(this.network).getSubsequentLinks();
        }
        return new CompressedNetworkRouteImpl(startLinkId, endLinkId, this.network, this.subsequentLinks);
    }

    @Override
    public String getCreatedRouteType() {
        return "links";
    }
}

