/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.population.routes.AbstractRoute;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.vehicles.Vehicle;

final class CompressedNetworkRouteImpl
extends AbstractRoute
implements NetworkRoute,
Cloneable {
    private static final Logger log = Logger.getLogger(CompressedNetworkRouteImpl.class);
    private ArrayList<Id<Link>> route = new ArrayList(0);
    private final Map<Id<Link>, Id<Link>> subsequentLinks;
    private double travelCost = Double.NaN;
    private int uncompressedLength = -1;
    private int modCount = 0;
    private int routeModCountState = 0;
    private Id<Vehicle> vehicleId = null;
    private final Network network;

    public CompressedNetworkRouteImpl(Id<Link> startLinkId, Id<Link> endLinkId, Network network, Map<Id<Link>, Id<Link>> subsequentLinks) {
        super(startLinkId, endLinkId);
        this.network = network;
        this.subsequentLinks = subsequentLinks;
    }

    @Override
    public CompressedNetworkRouteImpl clone() {
        CompressedNetworkRouteImpl cloned = (CompressedNetworkRouteImpl)super.clone();
        ArrayList<Id<Link>> tmpRoute = cloned.route;
        cloned.route = new ArrayList<Id<Link>>(tmpRoute);
        return cloned;
    }

    @Override
    public List<Id<Link>> getLinkIds() {
        if (this.uncompressedLength < 0) {
            return new ArrayList<Id<Link>>(0);
        }
        ArrayList<Id<Link>> links = new ArrayList<Id<Link>>(this.uncompressedLength);
        if (this.modCount != this.routeModCountState) {
            log.error("Route was modified after storing it! modCount=" + this.modCount + " routeModCount=" + this.routeModCountState);
            return links;
        }
        Id<Link> previousLinkId = this.getStartLinkId();
        Id<Link> endLinkId = this.getEndLinkId();
        if (previousLinkId == null || endLinkId == null) {
            return links;
        }
        if (previousLinkId.equals(endLinkId)) {
            return links;
        }
        for (Id<Link> linkId : this.route) {
            this.getLinksTillLink(links, linkId, previousLinkId);
            links.add(linkId);
            previousLinkId = linkId;
        }
        this.getLinksTillLink(links, endLinkId, previousLinkId);
        return links;
    }

    private void getLinksTillLink(List<Id<Link>> links, Id<Link> nextLinkId, Id<Link> startLinkId) {
        Id<Link> linkId = startLinkId;
        Link nextLink = this.network.getLinks().get(nextLinkId);
        Link link;
        while ((link = this.network.getLinks().get(linkId)).getToNode() != nextLink.getFromNode()) {
            linkId = this.subsequentLinks.get(linkId);
            links.add(linkId);
        }
        return;
    }

    @Override
    public NetworkRoute getSubRoute(Id<Link> fromLinkId, Id<Link> toLinkId) {
        boolean foundFromLink;
        ArrayList<Id<Link>> newLinkIds = new ArrayList<Id<Link>>(10);
        boolean collectLinks = foundFromLink = fromLinkId.equals(this.getStartLinkId());
        boolean equalFromTo = fromLinkId.equals(toLinkId);
        if (!foundFromLink || !equalFromTo) {
            for (Id<Link> linkId : this.getLinkIds()) {
                if (linkId.equals(toLinkId)) {
                    collectLinks = false;
                    if (equalFromTo) {
                        foundFromLink = true;
                    }
                    if (foundFromLink) break;
                }
                if (collectLinks) {
                    newLinkIds.add(linkId);
                }
                if (!linkId.equals(fromLinkId)) continue;
                foundFromLink = true;
                collectLinks = true;
                newLinkIds.clear();
            }
            if (!foundFromLink) {
                collectLinks = foundFromLink = fromLinkId.equals(this.getEndLinkId());
            }
            if (!foundFromLink) {
                throw new IllegalArgumentException("fromLinkId is not part of this route.");
            }
            if (collectLinks && toLinkId.equals(this.getEndLinkId())) {
                collectLinks = false;
            }
            if (collectLinks) {
                throw new IllegalArgumentException("toLinkId is not part of this route.");
            }
        }
        CompressedNetworkRouteImpl subRoute = new CompressedNetworkRouteImpl(fromLinkId, toLinkId, this.network, this.subsequentLinks);
        subRoute.setLinkIds(fromLinkId, newLinkIds, toLinkId);
        return subRoute;
    }

    @Override
    public double getTravelCost() {
        return this.travelCost;
    }

    @Override
    public void setTravelCost(double travelCost) {
        this.travelCost = travelCost;
    }

    @Override
    public void setLinkIds(Id<Link> startLinkId, List<Id<Link>> srcRoute, Id<Link> endLinkId) {
        this.route.clear();
        this.setStartLinkId(startLinkId);
        this.setEndLinkId(endLinkId);
        this.routeModCountState = this.modCount;
        if (srcRoute == null || srcRoute.size() == 0) {
            this.uncompressedLength = 0;
            return;
        }
        Id<Link> previousLinkId = startLinkId;
        for (Id<Link> linkId : srcRoute) {
            if (!this.subsequentLinks.get(previousLinkId).equals(linkId)) {
                this.route.add(linkId);
            }
            previousLinkId = linkId;
        }
        this.route.trimToSize();
        this.uncompressedLength = srcRoute.size();
        this.setLocked();
    }

    @Override
    public Id<Vehicle> getVehicleId() {
        return this.vehicleId;
    }

    @Override
    public void setVehicleId(Id<Vehicle> vehicleId) {
        this.vehicleId = vehicleId;
    }

    @Override
    public String getRouteType() {
        return "links";
    }

    @Override
    public String getRouteDescription() {
        StringBuilder desc = new StringBuilder(100);
        desc.append(this.getStartLinkId().toString());
        for (Id<Link> linkId : this.getLinkIds()) {
            desc.append(" ");
            desc.append(linkId.toString());
        }
        if (!this.getEndLinkId().equals(this.getStartLinkId()) || this.getLinkIds().size() > 0) {
            desc.append(" ");
            desc.append(this.getEndLinkId().toString());
        }
        return desc.toString();
    }

    @Override
    public void setRouteDescription(String routeDescription) {
        List<Id<Link>> linkIds = NetworkUtils.getLinkIds(routeDescription);
        Id<Link> startLinkId = this.getStartLinkId();
        Id<Link> endLinkId = this.getEndLinkId();
        if (linkIds.size() > 0) {
            startLinkId = linkIds.remove(0);
            this.setStartLinkId(startLinkId);
        }
        if (linkIds.size() > 0) {
            endLinkId = linkIds.remove(linkIds.size() - 1);
            this.setEndLinkId(endLinkId);
        }
        this.setLinkIds(startLinkId, linkIds, endLinkId);
    }
}

