/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.routes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.population.routes.AbstractRoute;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.vehicles.Vehicle;

final class LinkNetworkRouteImpl
extends AbstractRoute
implements NetworkRoute {
    static final String ROUTE_TYPE = "links";
    private ArrayList<Id<Link>> route = new ArrayList();
    private List<Id<Link>> safeRoute = Collections.unmodifiableList(this.route);
    private double travelCost = Double.NaN;
    private Id<Vehicle> vehicleId = null;

    LinkNetworkRouteImpl(Id<Link> startLinkId, Id<Link> endLinkId) {
        super(startLinkId, endLinkId);
    }

    LinkNetworkRouteImpl(Id<Link> startLinkId, List<Id<Link>> linkIds, Id<Link> endLinkId) {
        super(startLinkId, endLinkId);
        this.setLinkIds(startLinkId, linkIds, endLinkId);
    }

    LinkNetworkRouteImpl(Id<Link> startLinkId, Id<Link>[] linkIds, Id<Link> endLinkId) {
        super(startLinkId, endLinkId);
        Collections.addAll(this.route, linkIds);
        this.route.trimToSize();
    }

    @Override
    public LinkNetworkRouteImpl clone() {
        LinkNetworkRouteImpl cloned = (LinkNetworkRouteImpl)super.clone();
        ArrayList<Id<Link>> tmp = cloned.route;
        cloned.route = new ArrayList<Id<Link>>(tmp);
        cloned.safeRoute = Collections.unmodifiableList(cloned.route);
        return cloned;
    }

    @Override
    public List<Id<Link>> getLinkIds() {
        return this.safeRoute;
    }

    @Override
    public NetworkRoute getSubRoute(Id<Link> fromLinkId, Id<Link> toLinkId) {
        int i;
        int n;
        int fromIndex = -1;
        int toIndex = -1;
        if (fromLinkId.equals(this.getStartLinkId())) {
            fromIndex = 0;
        } else {
            n = this.route.size();
            for (i = 0; i < n && fromIndex < 0; ++i) {
                if (!fromLinkId.equals(this.route.get(i))) continue;
                fromIndex = i + 1;
            }
            if (fromIndex < 0 && fromLinkId.equals(this.getEndLinkId())) {
                fromIndex = this.route.size();
            }
            if (fromIndex < 0) {
                throw new IllegalArgumentException("Cannot create subroute because fromLinkId is not part of the route.");
            }
        }
        if (fromLinkId.equals(toLinkId)) {
            toIndex = fromIndex - 1;
        } else {
            n = this.route.size();
            for (i = fromIndex; i < n && toIndex < 0; ++i) {
                if (fromLinkId.equals(this.route.get(i))) {
                    fromIndex = i + 1;
                }
                if (!toLinkId.equals(this.route.get(i))) continue;
                toIndex = i;
            }
            if (toIndex < 0 && toLinkId.equals(this.getEndLinkId())) {
                toIndex = this.route.size();
            }
            if (toIndex < 0) {
                throw new IllegalArgumentException("Cannot create subroute because toLinkId is not part of the route.");
            }
        }
        NetworkRoute ret = RouteUtils.createLinkNetworkRouteImpl(fromLinkId, toLinkId);
        if (toIndex > fromIndex) {
            ret.setLinkIds(fromLinkId, this.route.subList(fromIndex, toIndex), toLinkId);
        } else {
            ret.setLinkIds(fromLinkId, null, toLinkId);
        }
        return ret;
    }

    @Override
    public double getTravelCost() {
        return this.travelCost;
    }

    @Override
    public void setTravelCost(double travelCost) {
        this.travelCost = travelCost;
    }

    @Override
    public void setLinkIds(Id<Link> startLinkId, List<Id<Link>> srcRoute, Id<Link> endLinkId) {
        this.route.clear();
        this.setStartLinkId(startLinkId);
        this.setEndLinkId(endLinkId);
        if (srcRoute != null) {
            this.route.addAll(srcRoute);
        }
        this.route.trimToSize();
    }

    @Override
    public Id<Vehicle> getVehicleId() {
        return this.vehicleId;
    }

    @Override
    public void setVehicleId(Id<Vehicle> vehicleId) {
        this.vehicleId = vehicleId;
    }

    @Override
    public String getRouteDescription() {
        StringBuilder desc = new StringBuilder(100);
        desc.append(this.getStartLinkId().toString());
        for (Id<Link> linkId : this.getLinkIds()) {
            desc.append(" ");
            desc.append(linkId.toString());
        }
        if (!this.getEndLinkId().equals(this.getStartLinkId()) || this.getLinkIds().size() > 0) {
            desc.append(" ");
            desc.append(this.getEndLinkId().toString());
        }
        return desc.toString();
    }

    @Override
    public void setRouteDescription(String routeDescription) {
        List<Id<Link>> linkIds = NetworkUtils.getLinkIds(routeDescription);
        Id<Link> startLinkId = this.getStartLinkId();
        Id<Link> endLinkId = this.getEndLinkId();
        if (linkIds.size() > 0) {
            startLinkId = linkIds.remove(0);
            this.setStartLinkId(startLinkId);
        }
        if (linkIds.size() > 0) {
            endLinkId = linkIds.remove(linkIds.size() - 1);
            this.setEndLinkId(endLinkId);
        }
        this.setLinkIds(startLinkId, linkIds, endLinkId);
    }

    @Override
    public String getRouteType() {
        return ROUTE_TYPE;
    }

    @Override
    public String toString() {
        String str = super.toString();
        str = str + " linkIds=" + this.getLinkIds();
        str = str + " travelCost=" + this.getTravelCost();
        return str;
    }
}

