/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.routes;

import java.util.HashMap;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.population.routes.GenericRouteFactory;
import org.matsim.core.population.routes.LinkNetworkRouteFactory;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteFactory;
import org.matsim.pt.routes.ExperimentalTransitRoute;
import org.matsim.pt.routes.ExperimentalTransitRouteFactory;

public final class RouteFactories {
    private final Map<Class<? extends Route>, RouteFactory> routeFactories = new HashMap<Class<? extends Route>, RouteFactory>();
    private RouteFactory defaultFactory = new GenericRouteFactory();
    private final Map<String, Class<? extends Route>> type2class = new HashMap<String, Class<? extends Route>>();

    public RouteFactories() {
        this.setRouteFactory(NetworkRoute.class, new LinkNetworkRouteFactory());
        this.setRouteFactory(ExperimentalTransitRoute.class, new ExperimentalTransitRouteFactory());
    }

    public <R extends Route> R createRoute(Class<R> routeClass, Id<Link> startLinkId, Id<Link> endLinkId) {
        RouteFactory factory = this.routeFactories.get(routeClass);
        if (factory == null) {
            factory = this.defaultFactory;
        }
        return (R)factory.createRoute(startLinkId, endLinkId);
    }

    public void setRouteFactory(Class<? extends Route> routeClass, RouteFactory factory) {
        if (routeClass == null) {
            this.defaultFactory = factory;
        } else if (factory == null) {
            this.routeFactories.remove(routeClass);
        } else {
            this.routeFactories.put(routeClass, factory);
            this.type2class.put(factory.getCreatedRouteType(), routeClass);
        }
    }

    public Class<? extends Route> getRouteClassForType(String routeType) {
        Class<? extends Route> routeClass = this.type2class.get(routeType);
        if (routeClass == null) {
            routeClass = Route.class;
        }
        return routeClass;
    }
}

