/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.population.routes;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.population.routes.GenericRouteImpl;
import org.matsim.core.population.routes.LinkNetworkRouteImpl;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.pt.routes.ExperimentalTransitRoute;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;

public class RouteUtils {
    private static final Logger log = Logger.getLogger(RouteUtils.class);

    private RouteUtils() {
    }

    public static List<Node> getNodes(NetworkRoute route, Network network) {
        List<Id<Link>> linkIds = route.getLinkIds();
        ArrayList<Node> nodes = new ArrayList<Node>(linkIds.size() + 1);
        if (linkIds.size() > 0) {
            nodes.add(network.getLinks().get(linkIds.get(0)).getFromNode());
            for (Id<Link> linkId : linkIds) {
                Link link = network.getLinks().get(linkId);
                nodes.add(link.getToNode());
            }
        } else if (!route.getStartLinkId().equals(route.getEndLinkId())) {
            nodes.add(network.getLinks().get(route.getStartLinkId()).getToNode());
        }
        return nodes;
    }

    public static List<Link> getLinksFromNodes(List<Node> nodes) {
        ArrayList<Link> links = new ArrayList<Link>(nodes.size());
        Node prevNode = null;
        for (Node node : nodes) {
            Link foundLink;
            if (prevNode != null && (foundLink = RouteUtils.findLink(prevNode, node)) != null) {
                links.add(foundLink);
            }
            prevNode = node;
        }
        links.trimToSize();
        return links;
    }

    public static List<Link> getLinksFromNodeIds(Network network, List<Id<Node>> nodeIds) {
        ArrayList<Link> links = new ArrayList<Link>(nodeIds.size());
        Node prevNode = null;
        for (Id<Node> nodeId : nodeIds) {
            Link foundLink;
            Node node = network.getNodes().get(nodeId);
            if (prevNode != null && (foundLink = RouteUtils.findLink(prevNode, node)) != null) {
                links.add(foundLink);
            }
            prevNode = node;
        }
        links.trimToSize();
        return links;
    }

    private static Link findLink(Node prevNode, Node node) {
        for (Link link : prevNode.getOutLinks().values()) {
            if (!link.getToNode().equals(node)) continue;
            return link;
        }
        return null;
    }

    public static NetworkRoute getSubRoute(NetworkRoute route, Node fromNode, Node toNode, Network network) {
        Id fromLinkId = null;
        Id toLinkId = null;
        ArrayList<Id<Link>> linkIds = new ArrayList<Id<Link>>(route.getLinkIds().size() + 2);
        linkIds.add(route.getStartLinkId());
        linkIds.addAll(route.getLinkIds());
        linkIds.add(route.getEndLinkId());
        for (Id id : linkIds) {
            Link link = network.getLinks().get(id);
            if (link.getToNode() == fromNode) {
                fromLinkId = link.getId();
            }
            if (link.getFromNode() != toNode) continue;
            toLinkId = link.getId();
            break;
        }
        return route.getSubRoute(fromLinkId, toLinkId);
    }

    public static double calcDistanceExcludingStartEndLink(NetworkRoute route, Network network) {
        double dist = 0.0;
        for (Id<Link> linkId : route.getLinkIds()) {
            dist += network.getLinks().get(linkId).getLength();
        }
        return dist;
    }

    public static double calcDistance(NetworkRoute networkRoute, double relPosOnDepartureLink, double relPosOnArrivalLink, Network network) {
        double routeDistance = RouteUtils.calcDistanceExcludingStartEndLink(networkRoute, network);
        routeDistance += network.getLinks().get(networkRoute.getStartLinkId()).getLength() * (1.0 - relPosOnDepartureLink);
        routeDistance = !networkRoute.getStartLinkId().equals(networkRoute.getEndLinkId()) ? (routeDistance += network.getLinks().get(networkRoute.getEndLinkId()).getLength() * relPosOnArrivalLink) : (routeDistance -= network.getLinks().get(networkRoute.getEndLinkId()).getLength() * (1.0 - relPosOnArrivalLink));
        return routeDistance;
    }

    public static double calcDistance(LeastCostPathCalculator.Path path) {
        double length = 0.0;
        for (Link link : path.links) {
            length += link.getLength();
        }
        return length;
    }

    public static NetworkRoute createNetworkRoute(List<Id<Link>> routeLinkIds, Network network) {
        Id<Link> startLinkId = routeLinkIds.get(0);
        ArrayList<Id<Link>> linksBetween = routeLinkIds.size() > 2 ? routeLinkIds.subList(1, routeLinkIds.size() - 1) : new ArrayList<Id<Link>>(0);
        Id<Link> endLinkId = routeLinkIds.get(routeLinkIds.size() - 1);
        NetworkRoute route = RouteUtils.createLinkNetworkRouteImpl(startLinkId, endLinkId);
        route.setLinkIds(startLinkId, linksBetween, endLinkId);
        return route;
    }

    public static double calcDistance(ExperimentalTransitRoute route, TransitSchedule ts, Network network) {
        Id<TransitLine> lineId = route.getLineId();
        Id<TransitRoute> routeId = route.getRouteId();
        Id<TransitStopFacility> enterStopId = route.getAccessStopId();
        Id<TransitStopFacility> exitStopId = route.getEgressStopId();
        TransitLine line = ts.getTransitLines().get(lineId);
        TransitRoute tr = line.getRoutes().get(routeId);
        Id<Link> enterLinkId = ts.getFacilities().get(enterStopId).getLinkId();
        Id<Link> exitLinkId = ts.getFacilities().get(exitStopId).getLinkId();
        NetworkRoute nr = tr.getRoute();
        double dist = 0.0;
        boolean count = false;
        if (enterLinkId.equals(nr.getStartLinkId())) {
            count = true;
        }
        for (Id<Link> linkId : nr.getLinkIds()) {
            if (count) {
                Link l = network.getLinks().get(linkId);
                if (l == null) {
                    log.error("link is null; linkId=" + linkId + "; network=" + network);
                }
                dist += l.getLength();
            }
            if (enterLinkId.equals(linkId)) {
                count = true;
            }
            if (!exitLinkId.equals(linkId)) continue;
            count = false;
            break;
        }
        if (count) {
            Link l = network.getLinks().get(nr.getEndLinkId());
            dist += l.getLength();
        }
        return dist;
    }

    public static double calculateCoverage(NetworkRoute route1, NetworkRoute route2, Network network) {
        Gbl.assertNotNull(route1);
        Gbl.assertNotNull(route2);
        Gbl.assertNotNull(network);
        double routeLength = 0.0;
        double coveredLength = 0.0;
        for (Id<Link> id : route1.getLinkIds()) {
            Link link = network.getLinks().get(id);
            Gbl.assertNotNull(link);
            routeLength += link.getLength();
            if (!route2.getLinkIds().contains(id)) continue;
            coveredLength += link.getLength();
        }
        if (routeLength > 0.0) {
            return coveredLength / routeLength;
        }
        return 1.0;
    }

    public static Route createGenericRouteImpl(Id<Link> startLinkId, Id<Link> endLinkId) {
        return new GenericRouteImpl(startLinkId, endLinkId);
    }

    public static NetworkRoute createLinkNetworkRouteImpl(Id<Link> startLinkId, Id<Link> endLinkId) {
        return new LinkNetworkRouteImpl(startLinkId, endLinkId);
    }

    public static NetworkRoute createLinkNetworkRouteImpl(Id<Link> startLinkId, List<Id<Link>> linkIds, Id<Link> endLinkId) {
        return new LinkNetworkRouteImpl(startLinkId, linkIds, endLinkId);
    }

    public static NetworkRoute createLinkNetworkRouteImpl(Id<Link> startLinkId, Id<Link>[] linkIds, Id<Link> endLinkId) {
        return new LinkNetworkRouteImpl(startLinkId, linkIds, endLinkId);
    }
}

