/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.BasicPlan;
import org.matsim.api.core.v01.population.HasPlansAndId;
import org.matsim.core.replanning.GenericPlanStrategy;
import org.matsim.core.replanning.PlanStrategyImpl;
import org.matsim.core.replanning.ReplanningContext;
import org.matsim.core.replanning.modules.GenericPlanStrategyModule;
import org.matsim.core.replanning.selectors.PlanSelector;
import org.matsim.core.replanning.selectors.RandomUnscoredPlanSelector;

public class GenericPlanStrategyImpl<T extends BasicPlan, I>
implements GenericPlanStrategy<T, I> {
    private PlanSelector<T, I> planSelector = null;
    private GenericPlanStrategyModule<T> firstModule = null;
    private final ArrayList<GenericPlanStrategyModule<T>> modules = new ArrayList();
    private final ArrayList<T> plans = new ArrayList();
    private long counter = 0L;
    private ReplanningContext replanningContext;
    private static final Logger log = Logger.getLogger(PlanStrategyImpl.class);

    public GenericPlanStrategyImpl(PlanSelector<T, I> planSelector) {
        this.planSelector = planSelector;
    }

    public void addStrategyModule(GenericPlanStrategyModule<T> module) {
        if (this.firstModule == null) {
            this.firstModule = module;
        } else {
            this.modules.add(module);
        }
    }

    public int getNumberOfStrategyModules() {
        if (this.firstModule == null) {
            return 0;
        }
        return this.modules.size() + 1;
    }

    @Override
    public void run(HasPlansAndId<T, I> person) {
        ++this.counter;
        Object plan = new RandomUnscoredPlanSelector().selectPlan(person);
        if (plan == null) {
            plan = this.planSelector.selectPlan(person);
        }
        if (plan != null) {
            person.setSelectedPlan(plan);
        } else {
            log.error(this.planSelector + " returned no plan: not changing selected plan for person " + person);
        }
        if (this.firstModule != null) {
            plan = person.createCopyOfSelectedPlanAndMakeSelected();
            this.plans.add(plan);
            this.firstModule.handlePlan(plan);
        }
    }

    @Override
    public void init(ReplanningContext replanningContext0) {
        this.replanningContext = replanningContext0;
        if (this.firstModule != null) {
            this.firstModule.prepareReplanning(replanningContext0);
        }
    }

    @Override
    public void finish() {
        if (this.firstModule != null) {
            this.firstModule.finishReplanning();
            for (GenericPlanStrategyModule<BasicPlan> genericPlanStrategyModule : this.modules) {
                genericPlanStrategyModule.prepareReplanning(this.replanningContext);
                for (BasicPlan plan : this.plans) {
                    genericPlanStrategyModule.handlePlan(plan);
                }
                genericPlanStrategyModule.finishReplanning();
            }
        }
        this.plans.clear();
        log.info("Plan-Strategy finished, " + this.counter + " plans handled. Strategy: " + this.toString());
        this.counter = 0L;
    }

    public String toString() {
        StringBuilder name = new StringBuilder(20);
        name.append(this.planSelector.getClass().getSimpleName());
        if (this.firstModule != null) {
            name.append('_');
            name.append(this.firstModule.getClass().getSimpleName());
            for (GenericPlanStrategyModule<T> module : this.modules) {
                name.append('_');
                name.append(module.getClass().getSimpleName());
            }
        }
        return name.toString();
    }

    public PlanSelector<T, I> getPlanSelector() {
        return this.planSelector;
    }
}

