/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.BasicPlan;
import org.matsim.api.core.v01.population.HasPlansAndId;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.api.internal.MatsimManager;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.replanning.GenericPlanStrategy;
import org.matsim.core.replanning.ReplanningContext;
import org.matsim.core.replanning.selectors.GenericWorstPlanForRemovalSelector;
import org.matsim.core.replanning.selectors.PlanSelector;
import org.matsim.core.replanning.selectors.RandomPlanSelector;

public class GenericStrategyManager<PL extends BasicPlan, AG extends HasPlansAndId<? extends BasicPlan, AG>>
implements MatsimManager {
    private static final Logger log = Logger.getLogger(GenericStrategyManager.class);
    private final Map<String, StrategyWeights<PL, AG>> weightsPerSubpopulation = new HashMap<String, StrategyWeights<PL, AG>>();
    private int maxPlansPerAgent = 0;
    private PlanSelector<PL, AG> removalPlanSelector = new GenericWorstPlanForRemovalSelector<PL, AG>();
    private String subpopulationAttributeName = null;
    private MyStrategyChooser myStrategyChooser = new MyStrategyChooser();

    public final void setSubpopulationAttributeName(String name) {
        this.subpopulationAttributeName = name;
    }

    public final void addStrategy(GenericPlanStrategy<PL, AG> strategy, String subpopulation, double weight) {
        StrategyWeights<PL, AG> weights = this.getStrategyWeights(subpopulation);
        if (weights.strategies.contains(strategy)) {
            log.error("Strategy " + strategy + " is already defined for subpopulation " + subpopulation);
            log.error("This can lead to undefined behavior. Please only specify each strategy once");
            throw new IllegalStateException("Strategy " + strategy + " is already defined for subpopulation " + subpopulation);
        }
        weights.strategies.add(strategy);
        weights.weights.add(weight);
        weights.totalWeights += weight;
    }

    final boolean removeStrategy(GenericPlanStrategy<PL, AG> strategy, String subpopulation) {
        StrategyWeights<PL, AG> weights = this.getStrategyWeights(subpopulation);
        int idx = weights.strategies.indexOf(strategy);
        if (idx != -1) {
            weights.strategies.remove(idx);
            double weight = weights.weights.remove(idx);
            weights.totalWeights -= weight;
            return true;
        }
        return false;
    }

    private StrategyWeights<PL, AG> getStrategyWeights(String subpop) {
        StrategyWeights<Object, Object> weights = this.weightsPerSubpopulation.get(subpop);
        if (weights == null) {
            weights = new StrategyWeights();
            this.weightsPerSubpopulation.put(subpop, weights);
        }
        return weights;
    }

    final boolean changeWeightOfStrategy(GenericPlanStrategy<PL, AG> strategy, String subpopulation, double newWeight) {
        StrategyWeights<PL, AG> weights = this.getStrategyWeights(subpopulation);
        int idx = weights.strategies.indexOf(strategy);
        if (idx != -1) {
            double oldWeight = weights.weights.set(idx, newWeight);
            weights.totalWeights += newWeight - oldWeight;
            Logger.getLogger(this.getClass()).info(strategy.toString() + ": oldWeight=" + oldWeight + " newWeight=" + newWeight);
            return true;
        }
        return false;
    }

    public final void run(Iterable<? extends HasPlansAndId<PL, AG>> persons, Population population, int iteration, ReplanningContext replanningContext) {
        this.handleChangeRequests(iteration);
        this.run(persons, population, replanningContext);
    }

    final void run(Iterable<? extends HasPlansAndId<PL, AG>> persons, Population population, ReplanningContext replanningContext) {
        for (GenericPlanStrategy<PL, AG> genericPlanStrategy : this.distinctStrategies()) {
            genericPlanStrategy.init(replanningContext);
        }
        for (HasPlansAndId hasPlansAndId : persons) {
            GenericPlanStrategy<PL, AG> strategy;
            if (this.maxPlansPerAgent > 0 && hasPlansAndId.getPlans().size() > this.maxPlansPerAgent) {
                this.removePlans(hasPlansAndId, this.maxPlansPerAgent);
            }
            String subpopName = null;
            if (this.subpopulationAttributeName != null) {
                subpopName = (String)PopulationUtils.getPersonAttribute(hasPlansAndId, this.subpopulationAttributeName);
            }
            if ((strategy = this.chooseStrategy(hasPlansAndId, subpopName)) == null) {
                throw new RuntimeException("No strategy found! Have you defined at least one replanning strategy per subpopulation? Current subpopulation = " + subpopName);
            }
            strategy.run(hasPlansAndId);
        }
        for (GenericPlanStrategy genericPlanStrategy : this.distinctStrategies()) {
            genericPlanStrategy.finish();
        }
    }

    private Collection<GenericPlanStrategy<PL, AG>> distinctStrategies() {
        LinkedHashSet<GenericPlanStrategy<PL, AG>> strategies = new LinkedHashSet<GenericPlanStrategy<PL, AG>>();
        for (StrategyWeights<PL, AG> weights : this.weightsPerSubpopulation.values()) {
            strategies.addAll(weights.strategies);
        }
        return strategies;
    }

    private void removePlans(HasPlansAndId<PL, AG> person, int maxNumberOfPlans) {
        while (person.getPlans().size() > maxNumberOfPlans) {
            PL plan = this.removalPlanSelector.selectPlan(person);
            person.removePlan(plan);
            if (plan != person.getSelectedPlan()) continue;
            Object newPlanToSelect = new RandomPlanSelector<PL, AG>().selectPlan(person);
            if (newPlanToSelect == null) {
                throw new IllegalStateException("could not find a plan to select for person " + person);
            }
            person.setSelectedPlan(newPlanToSelect);
        }
    }

    final void handleChangeRequests(int iteration) {
        for (int ii = 0; ii <= iteration; ++ii) {
            for (Map.Entry<String, StrategyWeights<PL, AG>> wentry : this.weightsPerSubpopulation.entrySet()) {
                String subpop = wentry.getKey();
                StrategyWeights<PL, AG> weights = wentry.getValue();
                Map changes = weights.changeRequests.remove(ii);
                if (changes == null) continue;
                for (Map.Entry entry : changes.entrySet()) {
                    this.changeWeightOfStrategy(entry.getKey(), subpop, entry.getValue());
                }
            }
        }
    }

    GenericPlanStrategy<PL, AG> chooseStrategy(HasPlansAndId<PL, AG> person, String subpopulation) {
        return this.myStrategyChooser.chooseStrategy(person, subpopulation);
    }

    public final void setMaxPlansPerAgent(int maxPlansPerAgent) {
        this.maxPlansPerAgent = maxPlansPerAgent;
    }

    public final void addChangeRequest(int iteration, GenericPlanStrategy<PL, AG> strategy, String subpopulation, double newWeight) {
        StrategyWeights<PL, AG> weights = this.getStrategyWeights(subpopulation);
        Integer iter = iteration;
        Map iterationRequests = weights.changeRequests.get(iter);
        if (iterationRequests == null) {
            iterationRequests = new HashMap(3);
            weights.changeRequests.put(iter, iterationRequests);
        }
        iterationRequests.put(strategy, newWeight);
        Logger.getLogger(this.getClass()).info("added change request:  iteration=" + iter + " newWeight=" + newWeight + " strategy=" + strategy.toString());
    }

    public final void setPlanSelectorForRemoval(PlanSelector<PL, AG> planSelector) {
        Logger.getLogger(this.getClass()).info("setting PlanSelectorForRemoval to " + planSelector.getClass());
        this.removalPlanSelector = planSelector;
    }

    final int getMaxPlansPerAgent() {
        return this.maxPlansPerAgent;
    }

    public final List<GenericPlanStrategy<PL, AG>> getStrategies(String subpopulation) {
        return this.getStrategyWeights((String)subpopulation).unmodifiableStrategies;
    }

    public final List<Double> getWeights(String subpopulation) {
        return this.getStrategyWeights((String)subpopulation).unmodifiableWeights;
    }

    private class MyStrategyChooser
    implements StrategyChooser<PL, AG> {
        private MyStrategyChooser() {
        }

        @Override
        public GenericPlanStrategy<PL, AG> chooseStrategy(HasPlansAndId<PL, AG> person, String subpopulation) {
            StrategyWeights weights = GenericStrategyManager.this.getStrategyWeights(subpopulation);
            double rnd = MatsimRandom.getRandom().nextDouble() * weights.totalWeights;
            double sum = 0.0;
            int max = weights.weights.size();
            for (int i = 0; i < max; ++i) {
                if (!(rnd <= (sum += weights.weights.get(i).doubleValue()))) continue;
                return weights.strategies.get(i);
            }
            return null;
        }
    }

    private static interface StrategyChooser<T extends BasicPlan, I extends HasPlansAndId<? extends BasicPlan, I>> {
        public GenericPlanStrategy<T, I> chooseStrategy(HasPlansAndId<T, I> var1, String var2);
    }

    static class StrategyWeights<T extends BasicPlan, I> {
        final List<GenericPlanStrategy<T, I>> strategies = new ArrayList<GenericPlanStrategy<T, I>>();
        final List<GenericPlanStrategy<T, I>> unmodifiableStrategies = Collections.unmodifiableList(this.strategies);
        final List<Double> weights = new ArrayList<Double>();
        final List<Double> unmodifiableWeights = Collections.unmodifiableList(this.weights);
        double totalWeights = 0.0;
        final Map<Integer, Map<GenericPlanStrategy<T, I>, Double>> changeRequests = new TreeMap<Integer, Map<GenericPlanStrategy<T, I>, Double>>();

        StrategyWeights() {
        }
    }
}

