/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.api.internal.MatsimManager;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.config.groups.PlansConfigGroup;
import org.matsim.core.config.groups.StrategyConfigGroup;
import org.matsim.core.replanning.GenericPlanStrategy;
import org.matsim.core.replanning.GenericStrategyManager;
import org.matsim.core.replanning.PlanStrategy;
import org.matsim.core.replanning.ReplanningContext;
import org.matsim.core.replanning.ReplanningUtils;
import org.matsim.core.replanning.selectors.PlanSelector;

@Singleton
public class StrategyManager
implements MatsimManager {
    private static final Logger log = Logger.getLogger(StrategyManager.class);
    private final GenericStrategyManager<Plan, Person> delegate = new GenericStrategyManager();

    @Inject
    StrategyManager(StrategyConfigGroup strategyConfigGroup, PlansConfigGroup plansConfigGroup, ControlerConfigGroup controlerConfigGroup, Map<StrategyConfigGroup.StrategySettings, PlanStrategy> planStrategies) {
        this();
        this.setMaxPlansPerAgent(strategyConfigGroup.getMaxAgentPlanMemorySize());
        int globalInnovationDisableAfter = (int)((double)(controlerConfigGroup.getLastIteration() - controlerConfigGroup.getFirstIteration()) * strategyConfigGroup.getFractionOfIterationsToDisableInnovation() + (double)controlerConfigGroup.getFirstIteration());
        log.info("global innovation switch off after iteration: " + globalInnovationDisableAfter);
        this.setSubpopulationAttributeName(plansConfigGroup.getSubpopulationAttributeName());
        for (Map.Entry<StrategyConfigGroup.StrategySettings, PlanStrategy> entry : planStrategies.entrySet()) {
            PlanStrategy strategy = entry.getValue();
            StrategyConfigGroup.StrategySettings settings = entry.getKey();
            this.addStrategy(strategy, settings.getSubpopulation(), settings.getWeight());
            int maxIter = settings.getDisableAfter();
            if (!(maxIter <= globalInnovationDisableAfter && maxIter != -1 || ReplanningUtils.isOnlySelector(strategy))) {
                maxIter = globalInnovationDisableAfter;
            }
            if (maxIter < 0) continue;
            if (maxIter >= controlerConfigGroup.getFirstIteration()) {
                this.addChangeRequest(maxIter + 1, strategy, settings.getSubpopulation(), 0.0);
                continue;
            }
            this.changeWeightOfStrategy(strategy, settings.getSubpopulation(), 0.0);
        }
    }

    public StrategyManager() {
    }

    public final void setSubpopulationAttributeName(String name) {
        this.delegate.setSubpopulationAttributeName(name);
    }

    @Deprecated
    public final void addStrategyForDefaultSubpopulation(PlanStrategy strategy, double weight) {
        this.addStrategy(strategy, null, weight);
    }

    public final void addStrategy(PlanStrategy strategy, String subpopulation, double weight) {
        this.delegate.addStrategy(strategy, subpopulation, weight);
    }

    @Deprecated
    public final boolean removeStrategyForDefaultSubpopulation(PlanStrategy strategy) {
        return this.removeStrategy(strategy, null);
    }

    public final boolean removeStrategy(PlanStrategy strategy, String subpopulation) {
        return this.delegate.removeStrategy(strategy, subpopulation);
    }

    @Deprecated
    public final boolean changeWeightOfStrategyForDefaultSubpopulation(GenericPlanStrategy<Plan, Person> strategy, double newWeight) {
        return this.changeWeightOfStrategy(strategy, null, newWeight);
    }

    public final boolean changeWeightOfStrategy(GenericPlanStrategy<Plan, Person> strategy, String subpopulation, double newWeight) {
        return this.delegate.changeWeightOfStrategy(strategy, subpopulation, newWeight);
    }

    public final void run(Population population, int iteration, ReplanningContext replanningContext) {
        this.delegate.handleChangeRequests(iteration);
        this.run(population, replanningContext);
    }

    protected void beforePopulationRunHook(Population population, ReplanningContext replanningContext) {
    }

    public final void run(Population population, ReplanningContext replanningContext) {
        this.beforePopulationRunHook(population, replanningContext);
        this.delegate.run(population.getPersons().values(), population, replanningContext);
        this.afterRunHook(population);
    }

    protected void afterRunHook(Population population) {
    }

    public GenericPlanStrategy<Plan, Person> chooseStrategy(Person person, String subpopulation) {
        GenericPlanStrategy<Plan, Person> strategy = this.delegate.chooseStrategy(person, subpopulation);
        return strategy;
    }

    public final void setMaxPlansPerAgent(int maxPlansPerAgent) {
        this.delegate.setMaxPlansPerAgent(maxPlansPerAgent);
    }

    public final int getMaxPlansPerAgent() {
        return this.delegate.getMaxPlansPerAgent();
    }

    @Deprecated
    public final void addChangeRequestForDefaultSubpopulation(int iteration, PlanStrategy strategy, double newWeight) {
        this.addChangeRequest(iteration, strategy, null, newWeight);
    }

    public final void addChangeRequest(int iteration, PlanStrategy strategy, String subpopulation, double newWeight) {
        this.delegate.addChangeRequest(iteration, strategy, subpopulation, newWeight);
    }

    @Inject
    public final void setPlanSelectorForRemoval(PlanSelector<Plan, Person> planSelector) {
        this.delegate.setPlanSelectorForRemoval(planSelector);
    }

    @Deprecated
    public final List<GenericPlanStrategy<Plan, Person>> getStrategiesOfDefaultSubpopulation() {
        return this.getStrategies(null);
    }

    public final List<GenericPlanStrategy<Plan, Person>> getStrategies(String subpopulation) {
        return this.delegate.getStrategies(subpopulation);
    }

    @Deprecated
    public final List<Double> getWeightsOfDefaultSubpopulation() {
        return this.getWeights(null);
    }

    public final List<Double> getWeights(String subpopulation) {
        return this.delegate.getWeights(subpopulation);
    }
}

