/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning;

import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Provider;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.core.config.groups.StrategyConfigGroup;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.replanning.PlanStrategy;
import org.matsim.core.replanning.PlanStrategyImpl;
import org.matsim.core.replanning.ReplanningContext;
import org.matsim.core.replanning.ReplanningContextImpl;
import org.matsim.core.replanning.StrategyManager;
import org.matsim.core.replanning.modules.ExternalModule;
import org.matsim.core.replanning.selectors.RandomPlanSelector;
import org.matsim.core.replanning.strategies.DefaultPlanStrategiesModule;

public class StrategyManagerModule
extends AbstractModule {
    @Override
    public void install() {
        int externalCounter = 0;
        this.install(new DefaultPlanStrategiesModule());
        this.bind(StrategyManager.class).in(Singleton.class);
        this.bind(ReplanningContext.class).to(ReplanningContextImpl.class).asEagerSingleton();
        MapBinder<StrategyConfigGroup.StrategySettings, PlanStrategy> planStrategyMapBinder = MapBinder.newMapBinder(this.binder(), StrategyConfigGroup.StrategySettings.class, PlanStrategy.class);
        for (StrategyConfigGroup.StrategySettings settings : this.getConfig().strategy().getStrategySettings()) {
            String name = settings.getStrategyName();
            if (name.equals("ExternalModule")) {
                planStrategyMapBinder.addBinding(settings).toProvider(new ExternalModuleProvider(++externalCounter, settings.getExePath()));
                continue;
            }
            if (name.contains(".")) {
                if (name.startsWith("org.matsim.core")) {
                    throw new RuntimeException("Strategies in the org.matsim.core package must not be loaded by name!");
                }
                try {
                    Class<?> klass = Class.forName(name);
                    if (PlanStrategy.class.isAssignableFrom(klass)) {
                        planStrategyMapBinder.addBinding(settings).to(klass);
                        continue;
                    }
                    if (Provider.class.isAssignableFrom(klass)) {
                        planStrategyMapBinder.addBinding(settings).toProvider(klass);
                        continue;
                    }
                    throw new RuntimeException("You specified a class name as a strategy, but it is neither a PlanStrategy nor a Provider.");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("You specified something which looks like a class name as a strategy, but the class could not be found.", e);
                }
            }
            planStrategyMapBinder.addBinding(settings).to(Key.get(PlanStrategy.class, (Annotation)Names.named(settings.getStrategyName())));
        }
    }

    private static class ExternalModuleProvider
    implements Provider<PlanStrategy> {
        @Inject
        private OutputDirectoryHierarchy controlerIO;
        @Inject
        private Scenario scenario;
        private int externalCounter;
        private String exePath;

        public ExternalModuleProvider(int externalCounter, String exePath) {
            this.externalCounter = externalCounter;
            this.exePath = exePath;
        }

        @Override
        public PlanStrategy get() {
            PlanStrategyImpl.Builder builder = new PlanStrategyImpl.Builder(new RandomPlanSelector<Plan, Person>());
            builder.addStrategyModule(new ExternalModule(this.exePath, "ext" + this.externalCounter, this.controlerIO, this.scenario));
            return builder.build();
        }
    }
}

