/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.modules;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.replanning.PlanStrategyModule;
import org.matsim.core.config.groups.GlobalConfigGroup;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.replanning.ReplanningContext;
import org.matsim.core.utils.misc.Counter;

public abstract class AbstractMultithreadedModule
implements PlanStrategyModule {
    private final int numOfThreads;
    private PlanAlgoThread[] algothreads = null;
    private Thread[] threads = null;
    private PlanAlgorithm directAlgo = null;
    private String name = null;
    private int count = 0;
    private final AtomicReference<Throwable> hadException = new AtomicReference<Object>(null);
    private final ExceptionHandler exceptionHandler = new ExceptionHandler(this.hadException);
    private ReplanningContext replanningContext;
    private static final Logger log = Logger.getLogger(AbstractMultithreadedModule.class);

    public abstract PlanAlgorithm getPlanAlgoInstance();

    public AbstractMultithreadedModule(GlobalConfigGroup globalConfigGroup) {
        this.numOfThreads = globalConfigGroup.getNumberOfThreads();
    }

    public AbstractMultithreadedModule(int numOfThreads) {
        this.numOfThreads = numOfThreads;
    }

    protected void beforePrepareReplanningHook(ReplanningContext replanningContextTmp) {
    }

    protected void afterPrepareReplanningHook(ReplanningContext replanningContextTmp) {
    }

    @Override
    public final void prepareReplanning(ReplanningContext replanningContextTmp) {
        this.beforePrepareReplanningHook(replanningContextTmp);
        this.replanningContext = replanningContextTmp;
        if (this.numOfThreads == 0) {
            this.directAlgo = this.getPlanAlgoInstance();
        } else {
            this.initThreads();
        }
        this.afterPrepareReplanningHook(replanningContextTmp);
    }

    protected final ReplanningContext getReplanningContext() {
        return this.replanningContext;
    }

    @Override
    public final void handlePlan(Plan plan) {
        if (this.directAlgo == null) {
            this.algothreads[this.count % this.numOfThreads].addPlanToThread(plan);
            ++this.count;
        } else {
            this.directAlgo.run(plan);
        }
    }

    protected void beforeFinishReplanningHook() {
    }

    protected void afterFinishReplanningHook() {
    }

    @Override
    public final void finishReplanning() {
        this.beforeFinishReplanningHook();
        if (this.directAlgo == null) {
            log.info("[" + this.name + "] starting " + this.threads.length + " threads, handling " + this.count + " plans");
            for (Thread thread : this.threads) {
                thread.start();
            }
            try {
                for (Thread thread : this.threads) {
                    thread.join();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            log.info("[" + this.name + "] all " + this.threads.length + " threads finished.");
            Throwable throwable = this.hadException.get();
            if (throwable != null) {
                throw new RuntimeException("Some threads crashed, thus not all plans may have been handled.", throwable);
            }
        }
        this.algothreads = null;
        this.threads = null;
        this.replanningContext = null;
        this.count = 0;
        this.afterFinishReplanningHook();
    }

    private void initThreads() {
        if (this.threads != null) {
            throw new RuntimeException("threads are already initialized");
        }
        this.hadException.set(null);
        this.threads = new Thread[this.numOfThreads];
        this.algothreads = new PlanAlgoThread[this.numOfThreads];
        Counter counter = null;
        for (int i = 0; i < this.numOfThreads; ++i) {
            PlanAlgorithm algo = this.getPlanAlgoInstance();
            if (i == 0) {
                this.name = algo.getClass().getSimpleName();
                counter = new Counter("[" + this.name + "] handled plan # ");
            }
            PlanAlgoThread algothread = new PlanAlgoThread(algo, counter);
            Thread thread = new Thread((Runnable)algothread, this.name + "." + i);
            thread.setUncaughtExceptionHandler(this.exceptionHandler);
            this.threads[i] = thread;
            this.algothreads[i] = algothread;
        }
    }

    final int getNumOfThreads() {
        return this.numOfThreads;
    }

    private static final class PlanAlgoThread
    implements Runnable {
        private final PlanAlgorithm planAlgo;
        private final List<Plan> plans = new LinkedList<Plan>();
        private final Counter counter;

        public PlanAlgoThread(PlanAlgorithm algo, Counter counter) {
            this.planAlgo = algo;
            this.counter = counter;
        }

        public void addPlanToThread(Plan plan) {
            this.plans.add(plan);
        }

        @Override
        public void run() {
            for (Plan plan : this.plans) {
                this.planAlgo.run(plan);
                this.counter.incCounter();
            }
        }
    }

    private static final class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final AtomicReference<Throwable> hadException;

        public ExceptionHandler(AtomicReference<Throwable> hadException) {
            this.hadException = hadException;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("Thread " + t.getName() + " died with exception. Will stop after all threads finished.", e);
            this.hadException.set(e);
        }
    }
}

