/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.modules;

import org.matsim.core.config.groups.ChangeModeConfigGroup;
import org.matsim.core.config.groups.GlobalConfigGroup;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.population.algorithms.ChooseRandomSingleLegMode;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.replanning.modules.AbstractMultithreadedModule;

public class ChangeSingleLegMode
extends AbstractMultithreadedModule {
    private String[] availableModes;
    private boolean ignoreCarAvailability;
    private boolean allowSwitchFromListedModesOnly;

    public ChangeSingleLegMode(GlobalConfigGroup globalConfigGroup, ChangeModeConfigGroup changeLegModeConfigGroup) {
        super(globalConfigGroup.getNumberOfThreads());
        this.availableModes = changeLegModeConfigGroup.getModes();
        this.ignoreCarAvailability = changeLegModeConfigGroup.getIgnoreCarAvailability();
        this.allowSwitchFromListedModesOnly = changeLegModeConfigGroup.getBehavior().equals((Object)ChangeModeConfigGroup.Behavior.fromSpecifiedModesToSpecifiedModes);
    }

    public ChangeSingleLegMode(int nOfThreads, String[] modes, boolean ignoreCarAvailabilty) {
        super(nOfThreads);
        this.availableModes = (String[])modes.clone();
        this.ignoreCarAvailability = ignoreCarAvailabilty;
    }

    @Override
    public PlanAlgorithm getPlanAlgoInstance() {
        ChooseRandomSingleLegMode algo = new ChooseRandomSingleLegMode(this.availableModes, MatsimRandom.getLocalInstance(), this.allowSwitchFromListedModesOnly);
        algo.setIgnoreCarAvailability(this.ignoreCarAvailability);
        return algo;
    }
}

