/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.modules;

import java.util.HashMap;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.PopulationWriter;
import org.matsim.api.core.v01.replanning.PlanStrategyModule;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigReader;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.config.ConfigWriter;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.algorithms.AbstractPersonAlgorithm;
import org.matsim.core.population.io.PopulationReader;
import org.matsim.core.replanning.ReplanningContext;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.utils.misc.ExeRunner;

public class ExternalModule
implements PlanStrategyModule {
    private static final String SCENARIO = "scenario";
    private static final String SCENARIO_INPUT_PLANS_FILENAME = "inputPlansFilename";
    private static final String SCENARIO_WORKING_PLANS_FILENAME = "workingPlansFilename";
    private static final String SCENARIO_WORKING_EVENTS_TXT_FILENAME = "workingEventsTxtFilename";
    private static final String SCENARIO_NETWORK_FILENAME = "networkFilename";
    private static final String ExternalInFileName = "plans.in.xml";
    private static final String ExternalOutFileName = "plans.out.xml";
    private static final String ExternalConfigFileName = "config.xml";
    private final Scenario scenario;
    private final ExeRunnerDelegate exeRunnerDelegate;
    private String modulePrefix = "";
    private String outFileRoot = "";
    private final OutputDirectoryHierarchy controler;
    private int currentIteration = -1;
    private Population exportPopulation;
    private Map<Id<Person>, Plan> plansToMutate = new HashMap<Id<Person>, Plan>();

    public ExternalModule(final String exePath, String moduleId, final OutputDirectoryHierarchy controler, Scenario scenario) {
        this.modulePrefix = moduleId + "_";
        this.controler = controler;
        this.outFileRoot = controler.getTempPath() + "/";
        this.scenario = scenario;
        this.exeRunnerDelegate = new ExeRunnerDelegate(){

            @Override
            public boolean invoke() {
                String logfilename;
                String cmd = exePath + " " + ExternalModule.this.outFileRoot + ExternalModule.this.modulePrefix + ExternalModule.ExternalConfigFileName;
                return ExeRunner.run(cmd, logfilename = controler.getIterationFilename(ExternalModule.this.currentIteration, ExternalModule.this.modulePrefix + "stdout.log"), 3600) == 0;
            }
        };
    }

    ExternalModule(ExeRunnerDelegate exeRunnerDelegate, String moduleId, OutputDirectoryHierarchy controler, Scenario scenario) {
        this.modulePrefix = moduleId + "_";
        this.controler = controler;
        this.outFileRoot = controler.getTempPath() + "/";
        this.scenario = scenario;
        this.exeRunnerDelegate = exeRunnerDelegate;
    }

    @Override
    public void prepareReplanning(ReplanningContext replanningContext) {
        this.currentIteration = replanningContext.getIteration();
        this.exportPopulation = ScenarioUtils.createScenario(ConfigUtils.createConfig()).getPopulation();
    }

    @Override
    public void handlePlan(Plan plan) {
        Person personWithOnlySelectedPlan = this.exportPopulation.getFactory().createPerson(plan.getPerson().getId());
        Plan planForNewPerson = PopulationUtils.createPlan(personWithOnlySelectedPlan);
        PopulationUtils.copyFromTo(plan, planForNewPerson);
        personWithOnlySelectedPlan.addPlan(planForNewPerson);
        this.exportPopulation.addPerson(personWithOnlySelectedPlan);
        this.plansToMutate.put(plan.getPerson().getId(), plan);
    }

    @Override
    public void finishReplanning() {
        this.exportPopulation();
        this.prepareExternalExeConfig();
        boolean successful = this.exeRunnerDelegate.invoke();
        if (!successful) {
            throw new RuntimeException("External Replanning exited with error.");
        }
        this.importPopulationAndMutatePlans();
    }

    private void exportPopulation() {
        String filename = this.outFileRoot + this.modulePrefix + ExternalInFileName;
        PopulationWriter plansWriter = new PopulationWriter(this.exportPopulation, this.scenario.getNetwork());
        plansWriter.write(filename);
    }

    private void prepareExternalExeConfig() {
        Config extConfig;
        String configFileName = this.scenario.getConfig().strategy().getExternalExeConfigTemplate();
        if (configFileName == null) {
            extConfig = new Config();
        } else {
            extConfig = new Config();
            ConfigReader reader = new ConfigReader(extConfig);
            reader.readFile(configFileName);
        }
        extConfig.setParam(SCENARIO, SCENARIO_INPUT_PLANS_FILENAME, this.outFileRoot + "/" + this.modulePrefix + ExternalInFileName);
        extConfig.setParam(SCENARIO, SCENARIO_WORKING_PLANS_FILENAME, this.outFileRoot + "/" + this.modulePrefix + ExternalOutFileName);
        extConfig.setParam(SCENARIO, SCENARIO_WORKING_EVENTS_TXT_FILENAME, this.controler.getIterationFilename(this.currentIteration - 1, "events.txt"));
        String networkFilename = this.scenario.getConfig().findParam("network", "inputNetworkFile");
        extConfig.setParam(SCENARIO, SCENARIO_NETWORK_FILENAME, networkFilename);
        new ConfigWriter(extConfig).write(this.outFileRoot + this.modulePrefix + ExternalConfigFileName);
    }

    private void importPopulationAndMutatePlans() {
        Scenario dummyScenario = ScenarioUtils.createScenario(ConfigUtils.createConfig());
        PopulationReader plansReader = new PopulationReader(dummyScenario);
        Population plans = dummyScenario.getPopulation();
        plansReader.readFile(this.outFileRoot + this.modulePrefix + ExternalOutFileName);
        new UpdatePlansAlgo().run(plans);
    }

    private class UpdatePlansAlgo
    extends AbstractPersonAlgorithm {
        private UpdatePlansAlgo() {
        }

        @Override
        public void run(Person dummyPerson) {
            Plan newPlan = (Plan)dummyPerson.getPlans().get(0);
            Plan planToMutate = (Plan)ExternalModule.this.plansToMutate.get(dummyPerson.getId());
            planToMutate.getPlanElements().clear();
            PopulationUtils.copyFromTo(newPlan, planToMutate);
        }
    }

    static interface ExeRunnerDelegate {
        public boolean invoke();
    }
}

