/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.modules;

import org.matsim.api.core.v01.population.Plan;
import org.matsim.core.config.Config;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.replanning.modules.AbstractMultithreadedModule;
import org.matsim.withinday.controller.ExecutedPlansService;

public class KeepLastExecuted
extends AbstractMultithreadedModule {
    private ExecutedPlansService executedPlans;

    public KeepLastExecuted(Config config, ExecutedPlansService executedPlans) {
        super(config.global());
        this.executedPlans = executedPlans;
    }

    @Override
    public PlanAlgorithm getPlanAlgoInstance() {
        return new PlanAlgorithm(){

            @Override
            public void run(Plan plan) {
                Plan newPlan = KeepLastExecuted.this.executedPlans.getExecutedPlans().get(plan.getPerson().getId());
                Gbl.assertNotNull(newPlan);
                PopulationUtils.copyFromTo(newPlan, plan);
            }
        };
    }
}

