/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.modules;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.replanning.PlanStrategyModule;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.replanning.ReplanningContext;
import org.matsim.core.router.TripStructureUtils;

public class ModeAndRouteConsistencyChecker
implements PlanStrategyModule {
    @Override
    public void prepareReplanning(ReplanningContext replanningContext) {
    }

    @Override
    public void handlePlan(Plan plan) {
        block8: for (Leg leg : TripStructureUtils.getLegs(plan)) {
            if (!(leg.getRoute() instanceof NetworkRoute)) continue;
            switch (leg.getMode()) {
                case "car": 
                case "bike": 
                case "walk": {
                    continue block8;
                }
            }
            Logger.getLogger(this.getClass()).warn("route is of type=" + leg.getRoute().getClass());
            Logger.getLogger(this.getClass()).warn("mode=" + leg.getMode());
            throw new RuntimeException("inconsistent");
        }
    }

    @Override
    public void finishReplanning() {
    }
}

