/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.modules;

import javax.inject.Provider;
import org.matsim.core.config.groups.GlobalConfigGroup;
import org.matsim.core.config.groups.SubtourModeChoiceConfigGroup;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.population.algorithms.ChooseRandomLegModeForSubtour;
import org.matsim.core.population.algorithms.PermissibleModesCalculator;
import org.matsim.core.population.algorithms.PermissibleModesCalculatorImpl;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.replanning.modules.AbstractMultithreadedModule;
import org.matsim.core.router.TripRouter;

public class SubtourModeChoice
extends AbstractMultithreadedModule {
    private final double probaForChangeSingleTripMode;
    private Behavior behavior = Behavior.fromSpecifiedModesToSpecifiedModes;
    private final Provider<TripRouter> tripRouterProvider;
    private PermissibleModesCalculator permissibleModesCalculator;
    private final String[] chainBasedModes;
    private final String[] modes;

    public SubtourModeChoice(Provider<TripRouter> tripRouterProvider, GlobalConfigGroup globalConfigGroup, SubtourModeChoiceConfigGroup subtourModeChoiceConfigGroup) {
        this(globalConfigGroup.getNumberOfThreads(), subtourModeChoiceConfigGroup.getModes(), subtourModeChoiceConfigGroup.getChainBasedModes(), subtourModeChoiceConfigGroup.considerCarAvailability(), subtourModeChoiceConfigGroup.getProbaForRandomSingleTripMode(), tripRouterProvider);
        this.setBehavior(subtourModeChoiceConfigGroup.getBehavior());
    }

    public SubtourModeChoice(int numberOfThreads, String[] modes, String[] chainBasedModes, boolean considerCarAvailability, double probaForChangeSingleTripMode, Provider<TripRouter> tripRouterProvider) {
        super(numberOfThreads);
        this.probaForChangeSingleTripMode = probaForChangeSingleTripMode;
        this.tripRouterProvider = tripRouterProvider;
        this.modes = (String[])modes.clone();
        this.chainBasedModes = (String[])chainBasedModes.clone();
        this.permissibleModesCalculator = new PermissibleModesCalculatorImpl(this.modes, considerCarAvailability);
    }

    @Deprecated
    public final void setBehavior(Behavior behavior) {
        this.behavior = behavior;
    }

    protected String[] getModes() {
        return (String[])this.modes.clone();
    }

    @Override
    public PlanAlgorithm getPlanAlgoInstance() {
        TripRouter tripRouter = this.tripRouterProvider.get();
        ChooseRandomLegModeForSubtour chooseRandomLegMode = new ChooseRandomLegModeForSubtour(tripRouter.getStageActivityTypes(), tripRouter.getMainModeIdentifier(), this.permissibleModesCalculator, this.modes, this.chainBasedModes, MatsimRandom.getLocalInstance(), this.behavior, this.probaForChangeSingleTripMode);
        return chooseRandomLegMode;
    }

    public void setPermissibleModesCalculator(PermissibleModesCalculator permissibleModesCalculator) {
        this.permissibleModesCalculator = permissibleModesCalculator;
    }

    public static enum Behavior {
        fromAllModesToSpecifiedModes,
        fromSpecifiedModesToSpecifiedModes;

    }
}

