/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.replanning.modules;

import javax.inject.Provider;
import org.matsim.core.config.Config;
import org.matsim.core.config.groups.PlansConfigGroup;
import org.matsim.core.gbl.MatsimRandom;
import org.matsim.core.population.algorithms.PlanAlgorithm;
import org.matsim.core.population.algorithms.TripPlanMutateTimeAllocation;
import org.matsim.core.replanning.modules.AbstractMultithreadedModule;
import org.matsim.core.router.TripRouter;

public class TripTimeAllocationMutator
extends AbstractMultithreadedModule {
    private final Provider<TripRouter> tripRouterProvider;
    public static final String CONFIG_GROUP = "TimeAllocationMutator";
    public static final String CONFIG_MUTATION_RANGE = "mutationRange";
    private double mutationRange = 1800.0;
    private boolean useActivityDurations = true;
    private final boolean affectingDuration;

    public TripTimeAllocationMutator(Config config, Provider<TripRouter> tripRouterProvider) {
        super(config.global());
        this.tripRouterProvider = tripRouterProvider;
        this.mutationRange = config.timeAllocationMutator().getMutationRange();
        this.affectingDuration = config.timeAllocationMutator().isAffectingDuration();
        PlansConfigGroup.ActivityDurationInterpretation actDurInterpr = config.plans().getActivityDurationInterpretation();
        if (actDurInterpr == PlansConfigGroup.ActivityDurationInterpretation.minOfDurationAndEndTime) {
            this.useActivityDurations = true;
        } else if (actDurInterpr == PlansConfigGroup.ActivityDurationInterpretation.endTimeOnly) {
            this.useActivityDurations = false;
        } else {
            if (actDurInterpr == PlansConfigGroup.ActivityDurationInterpretation.tryEndTimeThenDuration) {
                throw new UnsupportedOperationException("need to clarify the correct setting here.  Probably not a big deal, but not done yet.  kai, aug'10");
            }
            throw new IllegalStateException("beahvior not defined for this configuration setting");
        }
    }

    public TripTimeAllocationMutator(Config config, Provider<TripRouter> tripRouterProvider, double mutationRange, boolean affectingDuration) {
        super(config.global());
        this.tripRouterProvider = tripRouterProvider;
        this.mutationRange = mutationRange;
        this.affectingDuration = affectingDuration;
    }

    @Override
    public PlanAlgorithm getPlanAlgoInstance() {
        TripPlanMutateTimeAllocation pmta = new TripPlanMutateTimeAllocation(this.tripRouterProvider.get().getStageActivityTypes(), this.mutationRange, this.affectingDuration, MatsimRandom.getLocalInstance());
        pmta.setUseActivityDurations(this.useActivityDurations);
        return pmta;
    }
}

